/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.bc.EntityNotFoundException;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContextImpl;
import com.atlassian.jira.plugin.componentpanel.ComponentTabPanel;
import com.atlassian.jira.plugin.componentpanel.ComponentTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.jira.web.action.util.PopularIssueTypesUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class BrowseComponent
extends AbstractPluggableTabPanelAction<ComponentTabPanelModuleDescriptor> {
    private final ProjectComponentManager projectComponentManager;
    private final WebResourceManager webResourceManager;
    private Long componentId;
    private Collection<IssueType> popularIssueTypes;
    private Collection<IssueType> otherIssueTypes;
    private final PopularIssueTypesUtil popularIssueTypesUtil;
    private final SearchService searchService;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private boolean noTitle = false;
    private static final String NO_TITLE = "noTitle";
    private boolean contentOnly = false;
    private boolean stateUpdateOnly;
    private ProjectTabPanelModuleDescriptor projectTab;
    private Long projectId;

    public BrowseComponent(ProjectComponentManager projectComponentManager, PluginAccessor pluginAccessor, WebResourceManager webResourceManager, PopularIssueTypesUtil popularIssueTypesUtil, SearchService searchService, ProjectManager projectManager, PermissionManager permissionManager) {
        super(pluginAccessor);
        super.setPersistenceKey("jira.component.browser.selected");
        this.projectComponentManager = projectComponentManager;
        this.webResourceManager = webResourceManager;
        this.popularIssueTypesUtil = popularIssueTypesUtil;
        this.searchService = searchService;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
    }

    protected String doExecute() {
        Project newProject;
        Project project = this.getSelectedProjectObject();
        if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
            this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
            return "permissionviolation";
        }
        if (project == null) {
            return this.getRedirect("/secure/BrowseProjects.jspa");
        }
        if (this.componentId != null) {
            ProjectComponent component = null;
            try {
                component = this.projectComponentManager.find(this.componentId);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                // empty catch block
            }
            if (component != null && component.getProjectId().equals(project.getId())) {
                if (!this.contentOnly) {
                    this.webResourceManager.requireResource("jira.webresources:ajaxhistory");
                    this.webResourceManager.requireResource("jira.webresources:browseproject");
                }
                if (this.stateUpdateOnly) {
                    return "stateupdate";
                }
                if (this.contentOnly) {
                    return "contentonly";
                }
                return "success";
            }
        }
        return this.getRedirect("/browse/" + project.getKey());
    }

    public boolean hasCreateIssuePermissionForProject() {
        return this.permissionManager.hasPermission(11, this.getProject(), this.getLoggedInApplicationUser());
    }

    public void setComponentId(Long id) {
        this.componentId = id;
    }

    public ProjectComponent getComponent() {
        try {
            return this.componentId == null ? null : this.projectComponentManager.find(this.componentId);
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ComponentTabPanelModuleDescriptor> getComponentTabPanels() {
        return this.getTabPanels();
    }

    public String getTabHtmlForJSON() throws IOException {
        String tabPanelHTML = this.getTabHtml();
        return JSONEscaper.escape((String)tabPanelHTML);
    }

    public String getTabHtml() throws IOException {
        ComponentTabPanelModuleDescriptor tabPanelDescriptor = (ComponentTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + this.getSelectedTab() + "' has been specified."));
            return "";
        }
        ComponentTabPanel panel = (ComponentTabPanel)tabPanelDescriptor.getModule();
        if (panel.showPanel((BrowseContext)this.getContext())) {
            boolean descriptorNoTitle;
            String tabHtml = panel.getHtml((BrowseContext)this.getContext());
            StringBuilder strBuilder = new StringBuilder();
            if (this.isContentOnly()) {
                SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
                this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
                strBuilder.append(writer.toString());
            }
            boolean bl = descriptorNoTitle = tabPanelDescriptor.getParams().containsKey(NO_TITLE) && "true".equalsIgnoreCase((String)tabPanelDescriptor.getParams().get(NO_TITLE));
            if (!this.isNoTitle() && !descriptorNoTitle) {
                strBuilder.append(this.getPageHeaderHtml());
            }
            strBuilder.append(tabHtml);
            return strBuilder.toString();
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    public String getTabLabel() {
        ComponentTabPanelModuleDescriptor tabPanel = (ComponentTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanel == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        return tabPanel.getLabel();
    }

    public Long getId() throws PermissionException {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public String getFullName(String username) {
        User user;
        String fullname = username == null ? "" : ((user = UserUtils.getUser((String)username)) != null ? user.getDisplayName() : username);
        return fullname;
    }

    public Project getProject() {
        return this.getSelectedProjectObject();
    }

    public boolean isHasProjectAdminPermission() {
        return this.permissionManager.hasPermission(23, this.getProject(), this.getLoggedInApplicationUser());
    }

    @Override
    protected List<ComponentTabPanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ComponentTabPanelModuleDescriptor.class);
    }

    @Override
    protected boolean isTabPanelHidden(ComponentTabPanelModuleDescriptor descriptor) throws PermissionException {
        return !((ComponentTabPanel)descriptor.getModule()).showPanel((BrowseContext)this.getContext());
    }

    private BrowseComponentContextImpl getContext() {
        return new BrowseComponentContextImpl(this.searchService, this.getComponent(), this.getLoggedInUser(), this.request);
    }

    public Collection<IssueType> getPopularIssueTypes() {
        if (this.popularIssueTypes == null) {
            this.popularIssueTypes = this.popularIssueTypesUtil.getPopularIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.popularIssueTypes;
    }

    public Collection<IssueType> getOtherIssueTypes() {
        if (this.otherIssueTypes == null) {
            this.otherIssueTypes = this.popularIssueTypesUtil.getOtherIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.otherIssueTypes;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isStateUpdateOnly() {
        return this.stateUpdateOnly;
    }

    public void setStateUpdateOnly(boolean stateUpdateOnly) {
        this.stateUpdateOnly = stateUpdateOnly;
    }

    public boolean isNoTitle() {
        return this.noTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    protected SoyTemplateRenderer getSoyRenderer() {
        return ComponentManager.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
    }

    protected String getPageHeaderHtml() {
        String headerHtml;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("mainContent", "<h2>" + this.getTabLabel() + "</h2>");
        try {
            headerHtml = this.getSoyRenderer().render("jira.webresources:soy-templates", "JIRA.Templates.Headers.pageHeader", data);
        }
        catch (SoyException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Failed to render page header template", (Throwable)e);
            }
            headerHtml = String.valueOf(data.get("mainContent"));
        }
        return headerHtml;
    }
}

