/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow.scheme;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizStringFieldComparator;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.web.action.admin.workflow.scheme.SelectProjectWorkflowScheme;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowScheme;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.jira.workflow.migration.AssignableWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.DraftWorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.MigrationHelperFactory;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationHelper;
import com.atlassian.jira.workflow.migration.WorkflowSchemeMigrationTaskAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

@WebSudoRequired
public class SelectProjectWorkflowSchemeStep2
extends SelectProjectWorkflowScheme {
    private final WorkflowManager workflowManager;
    private Boolean haveIssuesToMigrate;
    private final SearchProvider searchProvider;
    private static final String ABORTED_MIGRATION_MESSAGE_KEY = "admin.workflowmigration.aborted.defaultworkflow";
    private static final String FAILURE_MIGRATION_MESSAGE_KEY = "admin.workflowmigration.withfailure.defaultworkflow";
    private final ConstantsManager constantsManager;
    private final MigrationHelperFactory migrationHelperFactory;
    private WorkflowSchemeHelper<?> workflowSchemeHelper;

    public SelectProjectWorkflowSchemeStep2(WorkflowSchemeMigrationTaskAccessor taskAccessor, SearchProvider searchProvider, TaskManager taskManager, TaskDescriptorBean.Factory taskDescriptorFactory, WorkflowManager workflowManager, ConstantsManager constantsManager, WorkflowSchemeManager workflowSchemeManager, MigrationHelperFactory migrationHelperFactory) {
        super(taskAccessor, taskManager, workflowSchemeManager, taskDescriptorFactory);
        this.searchProvider = searchProvider;
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
        this.migrationHelperFactory = migrationHelperFactory;
    }

    @Override
    public String doDefault() throws Exception {
        List projects;
        if (this.isDraftMigration()) {
            AssignableWorkflowScheme existingScheme = this.getExistingScheme();
            projects = this.getWorkflowSchemeManager().getProjectsUsing(existingScheme);
        } else {
            projects = Collections.singletonList(this.getProjectObject());
        }
        this.setProjects(projects);
        this.validate();
        if (this.invalidInput()) {
            return "error";
        }
        if (this.getWorkflowSchemeHelper().doNothing()) {
            return this.redirectUser();
        }
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.validate();
        if (this.invalidInput()) {
            return "error";
        }
        if (this.getMigrationHelper().doQuickMigrate()) {
            return this.redirectUser();
        }
        try {
            return this.getWorkflowSchemeHelper().waitForUpdatesToFinishAndExecute(new Callable<String>(){

                @Override
                public String call() {
                    SelectProjectWorkflowSchemeStep2.this.getWorkflowSchemeHelper().reload();
                    SelectProjectWorkflowSchemeStep2.this.addMigrationMappings();
                    if (SelectProjectWorkflowSchemeStep2.this.invalidInput()) {
                        return SelectProjectWorkflowSchemeStep2.this.getResult();
                    }
                    return SelectProjectWorkflowSchemeStep2.this.getRedirect(SelectProjectWorkflowSchemeStep2.this.getMigrationHelper().migrateAsync().getProgressURL());
                }
            });
        }
        catch (RejectedExecutionException e) {
            return "error";
        }
    }

    private String redirectUser() throws Exception {
        return this.getRedirect(this.getRedirectURL());
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        this.getWorkflowSchemeHelper().validate();
    }

    private void addMigrationMappings() {
        Map params = ActionContext.getParameters();
        List<GenericValue> typesNeedingMigration = this.getMigrationHelper().getTypesNeedingMigration();
        for (GenericValue issueType : typesNeedingMigration) {
            Collection<GenericValue> statusesNeedingMigration = this.getMigrationHelper().getStatusesNeedingMigration(issueType);
            for (GenericValue status : statusesNeedingMigration) {
                String[] paramValue = (String[])params.get(this.getSelectListName(issueType, status));
                if (paramValue == null || paramValue.length != 1) {
                    this.addErrorMessage(this.getText("admin.errors.workflows.specify.mapping", issueType.getString("name"), status.getString("name")));
                    continue;
                }
                this.getMigrationHelper().addMapping(issueType, status, this.constantsManager.getStatus(paramValue[0]));
            }
        }
    }

    public long getNumAffectedIssues(GenericValue issueType) throws SearchException {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder whereBuilder = queryBuilder.where().defaultAnd();
        whereBuilder.issueType(new String[]{issueType.getString("id")});
        whereBuilder.project().inNumbers(this.getProjectIds());
        ArrayList<String> statuses = new ArrayList<String>();
        Collection<GenericValue> statusesNeedingMigration = this.getMigrationHelper().getStatusesNeedingMigration(issueType);
        for (GenericValue status : statusesNeedingMigration) {
            statuses.add(status.getString("id"));
        }
        if (!statuses.isEmpty()) {
            whereBuilder.status().inStrings(statuses);
        }
        return this.searchProvider.searchCountOverrideSecurity(queryBuilder.buildQuery(), this.getLoggedInUser());
    }

    public long getTotalAffectedIssues(GenericValue issueType) throws SearchException {
        JqlClauseBuilder queryBuilder = JqlQueryBuilder.newBuilder().where();
        queryBuilder.issueType(new String[]{issueType.getString("id")});
        queryBuilder.and();
        queryBuilder.project().inNumbers(this.getProjectIds());
        return this.searchProvider.searchCountOverrideSecurity(queryBuilder.buildQuery(), this.getLoggedInUser());
    }

    public JiraWorkflow getTargetWorkflow(GenericValue issueType) throws WorkflowException {
        return this.workflowManager.getWorkflowFromScheme(this.getWorkflowScheme(), issueType.getString("id"));
    }

    public JiraWorkflow getExistingWorkflow(GenericValue issueType) throws GenericEntityException, WorkflowException {
        return this.workflowManager.getWorkflowFromScheme((WorkflowScheme)this.getExistingScheme(), issueType.getString("id"));
    }

    public Collection getTargetStatuses(GenericValue issueType) throws WorkflowException, GenericEntityException {
        return this.getTargetWorkflow(issueType).getLinkedStatuses();
    }

    public String getSelectListName(GenericValue issueType, GenericValue status) {
        return "mapping_" + issueType.getString("id") + "_" + status.getString("id");
    }

    public boolean isHaveIssuesToMigrate() throws GenericEntityException {
        if (this.haveIssuesToMigrate == null) {
            this.haveIssuesToMigrate = this.getMigrationHelper().isHaveIssuesToMigrate();
        }
        return this.haveIssuesToMigrate;
    }

    public Collection getStatusesNeedingMigration(GenericValue issueType) {
        ArrayList<GenericValue> statuses = new ArrayList<GenericValue>(this.getMigrationHelper().getStatusesNeedingMigration(issueType));
        Collections.sort(statuses, new OfBizStringFieldComparator("sequence"));
        return statuses;
    }

    public static String getAbortedMigrationMessageKey() {
        return ABORTED_MIGRATION_MESSAGE_KEY;
    }

    public static String getFailureMigrationMessageKey() {
        return FAILURE_MIGRATION_MESSAGE_KEY;
    }

    private String getSchemeName() {
        WorkflowScheme scheme = this.getWorkflowScheme();
        if (scheme == null) {
            return this.getText("admin.common.words.default");
        }
        return scheme.getName();
    }

    public WorkflowSchemeMigrationHelper<?> getMigrationHelper() {
        return this.getWorkflowSchemeHelper().getMigrationHelper();
    }

    public WorkflowScheme getWorkflowScheme() {
        return this.getWorkflowSchemeHelper().getWorkflowScheme();
    }

    private WorkflowSchemeHelper getWorkflowSchemeHelper() {
        if (this.workflowSchemeHelper == null) {
            this.workflowSchemeHelper = this.isDraftMigration() ? new DraftWorkflowSchemeHelper() : new AssignableWorkflowSchemeHelper();
        }
        return this.workflowSchemeHelper;
    }

    private class DraftWorkflowSchemeHelper
    extends WorkflowSchemeHelper<DraftWorkflowScheme> {
        private DraftWorkflowSchemeHelper() {
        }

        @Override
        DraftWorkflowScheme doGetWorkflowScheme() throws GenericEntityException {
            AssignableWorkflowScheme existingScheme = SelectProjectWorkflowSchemeStep2.this.getExistingScheme();
            return SelectProjectWorkflowSchemeStep2.this.getWorkflowSchemeManager().getDraftForParent(existingScheme);
        }

        DraftWorkflowSchemeMigrationHelper doGetMigrationHelper() throws GenericEntityException {
            return SelectProjectWorkflowSchemeStep2.this.migrationHelperFactory.createMigrationHelper(SelectProjectWorkflowSchemeStep2.this.getProjectObject(), SelectProjectWorkflowSchemeStep2.this.getProjects(), (DraftWorkflowScheme)this.getWorkflowScheme());
        }

        @Override
        boolean doNothing() throws GenericEntityException {
            return false;
        }

        @Override
        void validate() {
            if (this.getWorkflowScheme() == null) {
                SelectProjectWorkflowSchemeStep2.this.addErrorMessage(SelectProjectWorkflowSchemeStep2.this.getText("admin.errors.workflows.scheme.no.draft"));
            }
        }

        @Override
        String waitForUpdatesToFinishAndExecute(Callable<String> task) throws Exception {
            return (String)SelectProjectWorkflowSchemeStep2.this.getWorkflowSchemeManager().waitForUpdatesToFinishAndExecute(SelectProjectWorkflowSchemeStep2.this.getExistingScheme(), task);
        }
    }

    private class AssignableWorkflowSchemeHelper
    extends WorkflowSchemeHelper<AssignableWorkflowScheme> {
        private AssignableWorkflowSchemeHelper() {
        }

        @Override
        AssignableWorkflowScheme doGetWorkflowScheme() {
            if (SelectProjectWorkflowSchemeStep2.this.getSchemeId() == null) {
                return SelectProjectWorkflowSchemeStep2.this.getWorkflowSchemeManager().getDefaultWorkflowScheme();
            }
            return SelectProjectWorkflowSchemeStep2.this.getWorkflowSchemeManager().getWorkflowSchemeObj(SelectProjectWorkflowSchemeStep2.this.getSchemeId().longValue());
        }

        AssignableWorkflowSchemeMigrationHelper doGetMigrationHelper() throws GenericEntityException {
            return SelectProjectWorkflowSchemeStep2.this.migrationHelperFactory.createMigrationHelper(SelectProjectWorkflowSchemeStep2.this.getProjectObject(), (AssignableWorkflowScheme)this.getWorkflowScheme());
        }

        @Override
        boolean doNothing() throws GenericEntityException {
            AssignableWorkflowScheme existingScheme = SelectProjectWorkflowSchemeStep2.this.getExistingScheme();
            Object targetScheme = this.getWorkflowScheme();
            return targetScheme == null && existingScheme == null || targetScheme != null && targetScheme.equals(existingScheme);
        }

        @Override
        void validate() {
        }

        @Override
        String waitForUpdatesToFinishAndExecute(Callable<String> task) throws Exception {
            return (String)SelectProjectWorkflowSchemeStep2.this.getWorkflowSchemeManager().waitForUpdatesToFinishAndExecute((AssignableWorkflowScheme)this.getWorkflowScheme(), task);
        }
    }

    private abstract class WorkflowSchemeHelper<T extends WorkflowScheme> {
        private T workflowScheme;
        private WorkflowSchemeMigrationHelper<T> migrationHelper;

        WorkflowSchemeHelper() {
            this.reload();
        }

        T getWorkflowScheme() {
            return this.workflowScheme;
        }

        WorkflowSchemeMigrationHelper<T> getMigrationHelper() {
            return this.migrationHelper;
        }

        void reload() {
            try {
                this.workflowScheme = this.doGetWorkflowScheme();
                if (this.workflowScheme != null) {
                    this.migrationHelper = this.doGetMigrationHelper();
                }
            }
            catch (GenericEntityException e) {
                throw new DataAccessException((Throwable)e);
            }
        }

        abstract void validate();

        abstract T doGetWorkflowScheme() throws GenericEntityException;

        abstract WorkflowSchemeMigrationHelper<T> doGetMigrationHelper() throws GenericEntityException;

        abstract boolean doNothing() throws GenericEntityException;

        abstract String waitForUpdatesToFinishAndExecute(Callable<String> var1) throws Exception;
    }
}

