/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.scheme;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.scheme.SchemeManagerFactory;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.ArrayList;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

public abstract class AbstractSchemeToolAction
extends JiraWebActionSupport {
    private String selectedSchemeType;
    private String[] selectedSchemeIds;
    private SchemeManagerFactory schemeManagerFactory;
    private SchemeFactory schemeFactory;
    private List<Scheme> selectedSchemeObjs;
    protected ApplicationProperties applicationProperties;
    private static final String SESSION_KEY_PREFIX = "__";
    private static final String SESSION_KEY_SUFFIX = "__selectedSchemeIds";

    public AbstractSchemeToolAction(SchemeManagerFactory schemeManagerFactory, SchemeFactory schemeFactory, ApplicationProperties applicationProperties) {
        this.schemeManagerFactory = schemeManagerFactory;
        this.schemeFactory = schemeFactory;
        this.applicationProperties = applicationProperties;
    }

    public String getSelectedSchemeType() {
        return this.selectedSchemeType;
    }

    public void setSelectedSchemeType(String selectedSchemeType) {
        this.selectedSchemeType = selectedSchemeType;
    }

    public boolean isHasSelectedSchemeIds() {
        String[] savedSelectedSchemeIds = (String[])ActionContext.getSession().get(this.getSelectedSchemeIdsSessionKey());
        return savedSelectedSchemeIds != null && savedSelectedSchemeIds.length > 0;
    }

    public String[] getSelectedSchemeIds() {
        if (this.selectedSchemeIds == null) {
            this.selectedSchemeIds = (String[])ActionContext.getSession().get(this.getSelectedSchemeIdsSessionKey());
        }
        return this.selectedSchemeIds;
    }

    public void setSelectedSchemeIds(String[] selectedSchemeIds) {
        this.selectedSchemeIds = selectedSchemeIds;
    }

    public void storeSelectedSchemeIdsInSession() {
        ActionContext.getSession().put(this.getSelectedSchemeIdsSessionKey(), this.selectedSchemeIds);
    }

    public void resetSelectedSchemeIds() {
        this.selectedSchemeIds = null;
        ActionContext.getSession().remove(this.getSelectedSchemeIdsSessionKey());
    }

    public String getToolName() {
        return null;
    }

    public String getSelectedSchemeIdsSessionKey() {
        return SESSION_KEY_PREFIX + this.getToolName() + SESSION_KEY_SUFFIX;
    }

    public SchemeFactory getSchemeFactory() {
        return this.schemeFactory;
    }

    public SchemeManagerFactory getSchemeManagerFactory() {
        return this.schemeManagerFactory;
    }

    protected SchemeManager getSchemeManager(String type) {
        return this.getSchemeManagerFactory().getSchemeManager(type);
    }

    protected List<Scheme> getSchemeObjs() {
        if (this.selectedSchemeObjs == null) {
            this.selectedSchemeObjs = new ArrayList<Scheme>();
            if (this.getSelectedSchemeIds() != null) {
                for (int i = 0; i < this.getSelectedSchemeIds().length; ++i) {
                    String selectedScheme = this.getSelectedSchemeIds()[i];
                    try {
                        this.selectedSchemeObjs.add(this.getSchemeForId(selectedScheme));
                        continue;
                    }
                    catch (Exception e) {
                        this.addErrorMessage(this.getText("admin.scheme.group.role.unable.to.resolve.id", selectedScheme));
                    }
                }
            }
        }
        return this.selectedSchemeObjs;
    }

    private Scheme getSchemeForId(String stringId) throws GenericEntityException {
        Long schemeId = new Long(Long.parseLong(stringId));
        return this.getSchemeFactory().getSchemeWithEntitiesComparable(this.getSchemeManager(this.getSelectedSchemeType()).getScheme(schemeId));
    }
}

