/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bulkedit.operation.BulkMigrateOperation;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.issue.bulkedit.BulkMigrate;
import com.atlassian.jira.web.bean.MultiBulkMoveBean;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

@WebSudoRequired
public class MigrateIssueTypes
extends BulkMigrate {
    private static final String BUTTON_NAME_NEXT = "nextBtn";
    private static final String BUTTON_NAME_PREVIOUS = "previousBtn";
    protected int currentStep = 1;
    protected String nextBtn;
    protected String previousBtn;
    protected String finishButton;

    public MigrateIssueTypes(BulkMoveOperation bulkMoveOperation, FieldManager fieldManager, WorkflowManager workflowManager, ConstantsManager constantsManager, IssueFactory issueFactory, BulkMigrateOperation bulkMigrateOperation, PermissionManager permissionManager, SearchService searchService) {
        super(searchService, bulkMoveOperation, fieldManager, workflowManager, constantsManager, issueFactory, bulkMigrateOperation, permissionManager);
    }

    @Override
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @Override
    public String doStart() throws Exception {
        return this.progressSteps();
    }

    @Override
    public String doChooseContext() throws Exception {
        this.getBulkEditBean().resetMoveData();
        this.getBulkMigrateOperation().chooseContextNoValidate(this.getRootBulkEditBean(), this.getLoggedInApplicationUser());
        Set invalidIssues = this.getBulkEditBean().getInvalidIssues();
        if (invalidIssues != null && !invalidIssues.isEmpty()) {
            for (Issue invalidIssue : invalidIssues) {
                this.addErrorMessage(this.getText("admin.errors.issuetypes.issue.has.nonexistent.status", "'" + invalidIssue.getKey() + "'", invalidIssue.getString("status")));
            }
            return "error";
        }
        this.progressSteps();
        if (this.currentStep == 1) {
            return "start";
        }
        if (this.isPreviousClicked()) {
            this.getRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToPreviousBulkEditBean();
            return "previous";
        }
        if (!this.getBulkMigrateOperation().isStatusValid(this.getRootBulkEditBean())) {
            return "choosestatus";
        }
        return "success";
    }

    @Override
    public String doChooseStatus() throws Exception {
        if (this.getBulkEditBean() == null) {
            return this.redirectToStart();
        }
        this.getBulkMigrateOperation().setStatusFields(this.getCurrentRootBulkEditBean());
        return this.progressSteps();
    }

    @Override
    public String doSetFields() throws Exception {
        this.getBulkMigrateOperation().validatePopulateFields(this.getRootBulkEditBean(), (I18nHelper)this, (ErrorCollection)this);
        if (this.invalidInput()) {
            return "input";
        }
        this.progressSteps();
        if (this.currentStep == this.getTotalSteps()) {
            return "confirm";
        }
        if (this.isPreviousClicked()) {
            if (!this.getBulkMigrateOperation().isStatusValid(this.getRootBulkEditBean())) {
                return "choosestatus";
            }
            return "previous";
        }
        this.getRootBulkEditBean().getRelatedMultiBulkMoveBean().progressToNextBulkEditBean();
        return "success";
    }

    @Override
    public String doPerform() throws Exception {
        if (this.isFinishClicked()) {
            if (!this.getBulkMigrateOperation().canPerform(this.getRootBulkEditBean(), this.getLoggedInApplicationUser())) {
                this.addErrorMessage(this.getText("bulk.edit.cannotperform.error", String.valueOf(this.getBulkEditBean().getSelectedIssues().size())));
                return "input";
            }
            MultiBulkMoveBean multiBulkMoveBean = this.getMultiBulkMoveBean();
            multiBulkMoveBean.getExecutableAction().run();
            try {
                this.getBulkMigrateOperation().perform(this.getRootBulkEditBean(), this.getLoggedInApplicationUser());
            }
            catch (Exception e) {
                this.log.error((Object)"Error while performing Bulk Edit operation.", (Throwable)e);
                this.addErrorMessage(this.getText("bulk.edit.perform.error"));
                return "error";
            }
            return this.getRedirect(multiBulkMoveBean.getFinalLocation());
        }
        return this.progressSteps();
    }

    @Override
    public IssueContext getCurrentIssueContext() {
        return this.getMultiBulkMoveBean().getCurrentIssueContext();
    }

    public int getTotalSteps() {
        return this.getMultiBulkMoveBean().getIssuesInContext().size() * 2 + 2 + this.getMultiBulkMoveBean().getNumberOfStatusChangeRequired(this.bulkMoveOperation);
    }

    private List getAvailableIssueTypeOptions() {
        Collection selectedOptions = this.getMultiBulkMoveBean().getSelectedOptions();
        ArrayList<IssueConstantOption> selectedOptionsList = new ArrayList<IssueConstantOption>();
        for (Object selectedOption : selectedOptions) {
            String optionId = (String)selectedOption;
            IssueType constantObject = this.constantsManager.getIssueTypeObject(optionId);
            selectedOptionsList.add(new IssueConstantOption((IssueConstant)constantObject));
        }
        return selectedOptionsList;
    }

    public String getIssueTypeEditHtml() {
        IssueTypeField issueTypeField = this.fieldManager.getIssueTypeField();
        final GenericValue issueType = this.getBulkEditBean().getTargetIssueTypeGV();
        OperationContext operationContext = new OperationContext(){

            public Map<String, Object> getFieldValuesHolder() {
                return EasyMap.build((Object)"issuetype", (Object)(issueType != null ? issueType.getString("id") : ""));
            }

            public IssueOperation getIssueOperation() {
                return MigrateIssueTypes.this.getBulkMigrateOperation();
            }
        };
        List options = !this.getBulkEditBean().isSubTaskCollection() ? this.getMultiBulkMoveBean().getRegularOptions() : this.getMultiBulkMoveBean().getSubTaskOptions();
        return issueTypeField.getEditHtml(operationContext, (Action)this, options);
    }

    protected String progressSteps() throws Exception {
        if (this.isPreviousClicked()) {
            --this.currentStep;
        } else if (this.isNextClicked()) {
            ++this.currentStep;
        }
        if (this.isPreviousClicked()) {
            return "previous";
        }
        if (this.isNextClicked()) {
            return "success";
        }
        return "input";
    }

    protected boolean isPreviousClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_PREVIOUS);
    }

    protected boolean isNextClicked() {
        return this.isButtonClickedByName(BUTTON_NAME_NEXT);
    }

    protected boolean isFinishClicked() {
        return this.isNextClicked() && this.getCurrentStep() >= this.getTotalSteps();
    }

    protected boolean isButtonClickedByName(String name) {
        return StringUtils.isNotBlank((String)ParameterUtils.getStringParam((Map)ActionContext.getParameters(), (String)name));
    }

    protected boolean isButtonClicked(String buttonValue, String buttonName) {
        if (buttonValue == null) {
            return false;
        }
        return buttonValue.toLowerCase().indexOf(buttonName.toLowerCase()) >= 0;
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int currentStep) {
        this.currentStep = currentStep;
    }

    public String getNextBtn() {
        return this.nextBtn;
    }

    public void setNextBtn(String nextBtn) {
        this.nextBtn = nextBtn;
    }

    public String getPreviousBtn() {
        return this.previousBtn;
    }

    public void setPreviousBtn(String previousBtn) {
        this.previousBtn = previousBtn;
    }

    public String getFinishButton() {
        return this.finishButton;
    }

    public void setFinishButton(String finishButton) {
        this.finishButton = finishButton;
    }
}

