/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.scheme.AbstractEditScheme;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.JiraEntityUtils;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditScheme
extends AbstractEditScheme {
    private Long defaultLevel;

    @Override
    public SchemeManager getSchemeManager() {
        return ManagerFactory.getIssueSecuritySchemeManager();
    }

    @Override
    public String getRedirectURL() {
        return "ViewIssueSecuritySchemes.jspa";
    }

    @Override
    public String doDefault() throws Exception {
        this.setDefaultLevel(this.getScheme().getLong("defaultlevel"));
        return super.doDefault();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        GenericValue updatedScheme = this.getScheme();
        updatedScheme.setString("name", this.getName());
        updatedScheme.setString("description", this.getDescription());
        updatedScheme.set("defaultlevel", (Object)this.getDefaultLevel());
        ManagerFactory.getIssueSecuritySchemeManager().updateScheme(updatedScheme);
        return this.getRedirect(this.getRedirectURL());
    }

    public Long getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(Long defaultLevel) {
        this.defaultLevel = defaultLevel == null || defaultLevel.equals(new Long(-1L)) ? null : defaultLevel;
    }

    public Map getSecurityLevels() {
        return JiraEntityUtils.createEntityMap(ManagerFactory.getIssueSecurityLevelManager().getSchemeIssueSecurityLevels(this.getSchemeId()), "id", "name");
    }
}

