/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.fields.screen.issuetype.ProjectIssueTypeScreenSchemeHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeItemAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class ConfigureFieldScreenScheme
extends AbstractFieldScreenSchemeItemAction {
    private final ProjectIssueTypeScreenSchemeHelper helper;
    private List<Project> projects;

    public ConfigureFieldScreenScheme(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager, ProjectIssueTypeScreenSchemeHelper helper) {
        super(fieldScreenSchemeManager, fieldScreenManager);
        this.helper = helper;
    }

    protected void doValidation() {
        this.validateId();
    }

    public String doExecute() throws Exception {
        return this.getResult();
    }

    @RequiresXsrfCheck
    public String doDeleteFieldScreenSchemeItem() {
        this.validateIssueOperationId();
        if (!this.invalidInput()) {
            this.getFieldScreenScheme().removeFieldScreenSchemeItem(this.getIssueOperation());
            return this.redirectToView();
        }
        return this.getResult();
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            this.projects = this.helper.getProjectsForFieldScreenScheme(fieldScreenScheme);
        }
        return this.projects;
    }
}

