/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.XMLUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.DateTimeVelocityUtils;
import com.atlassian.jira.datetime.DateVelocityUtils;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.plugin.keyboardshortcut.KeyboardShortcutManager;
import com.atlassian.jira.plugin.profile.UserFormatManager;
import com.atlassian.jira.render.Encoder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.MemoizingMap;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.bean.PermissionCheckBean;
import com.atlassian.jira.web.component.IssueConstantWebComponent;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.jira.web.util.ExternalLinkUtilImpl;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.util.concurrent.LazyReference;
import com.opensymphony.util.TextUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.app.FieldMethodizer;

public class JiraVelocityUtils {
    private static final MemoizingMap.Master<String, Object> MASTER;

    public static Map<String, Object> getDefaultVelocityParams(JiraAuthenticationContext authenticationContext) {
        return JiraVelocityUtils.getDefaultVelocityParams(new HashMap<String, Object>(), authenticationContext);
    }

    public static Map<String, Object> getDefaultVelocityParams(Map<String, Object> startingParams, JiraAuthenticationContext authenticationContext) {
        startingParams = startingParams == null ? new HashMap() : startingParams;
        return CompositeMap.of(startingParams, JiraVelocityUtils.createVelocityParams(authenticationContext));
    }

    public static Map<String, Object> createVelocityParams(JiraAuthenticationContext authenticationContext) {
        HashMap<String, Object> localParams = new HashMap<String, Object>();
        localParams.put("currentCalendar", new LazyCalendar(authenticationContext.getLocale(), (ApplicationProperties)ComponentAccessor.getComponentOfType(ApplicationProperties.class)));
        localParams.put("authcontext", authenticationContext);
        localParams.put("outlookdate", authenticationContext.getOutlookDate());
        localParams.put("dateFormatter", JiraVelocityUtils.dateTimeFormatter().withStyle(DateTimeStyle.COMPLETE).forLoggedInUser());
        localParams.put("dateutils", (Object)new DateUtils(authenticationContext));
        localParams.put("permissionCheck", new PermissionCheckBean(authenticationContext, ComponentAccessor.getPermissionManager()));
        localParams.put("featureManager", ComponentAccessor.getComponent(FeatureManager.class));
        localParams.put("soyRenderer", ((SoyTemplateRendererProvider)ComponentAccessor.getComponent(SoyTemplateRendererProvider.class)).getRenderer());
        if (ExecutingHttpRequest.get() != null) {
            localParams.put("req", ExecutingHttpRequest.get());
        }
        return MASTER.combine(JiraMailQueueUtils.getContextParamsMaster()).toMap(localParams);
    }

    private static DateTimeFormatter dateTimeFormatter() {
        return (DateTimeFormatter)ComponentAccessor.getComponentOfType(DateTimeFormatter.class);
    }

    private static String getXsrfToken() {
        return JiraVelocityUtils.getXsrfTokenGenerator().generateToken();
    }

    private static XsrfTokenGenerator getXsrfTokenGenerator() {
        return (XsrfTokenGenerator)ComponentAccessor.getComponentOfType(XsrfTokenGenerator.class);
    }

    static {
        MemoizingMap.Master.Builder<String, Object> builder = MemoizingMap.Master.builder();
        builder.add("xmlutils", new XMLUtils());
        builder.add("textutils", new TextUtils());
        builder.add("urlcodec", new JiraUrlCodec());
        builder.add("urlModeAbsolute", UrlMode.ABSOLUTE);
        builder.add("dateTimeStyle", new FieldMethodizer(DateTimeStyle.class.getName()));
        builder.addLazy("currentMillis", new Supplier<Long>(){

            public Long get() {
                return System.currentTimeMillis();
            }
        });
        builder.addLazy("externalLinkUtil", new Supplier<ExternalLinkUtil>(){

            public ExternalLinkUtil get() {
                return ExternalLinkUtilImpl.getInstance();
            }
        });
        Supplier<VelocityRequestContext> requestContext = new Supplier<VelocityRequestContext>(){

            public VelocityRequestContext get() {
                return new DefaultVelocityRequestContextFactory(ComponentAccessor.getApplicationProperties()).getJiraVelocityRequestContext();
            }
        };
        builder.addLazy("requestContext", requestContext);
        builder.addLazy("baseurl", new Supplier<String>((Supplier)requestContext){
            final /* synthetic */ Supplier val$requestContext;
            {
                this.val$requestContext = supplier;
            }

            public String get() {
                return ((VelocityRequestContext)this.val$requestContext.get()).getBaseUrl();
            }
        });
        builder.addLazy("issueConstantWebComponent", new Supplier<IssueConstantWebComponent>(){

            public IssueConstantWebComponent get() {
                return new IssueConstantWebComponent();
            }
        });
        builder.addLazy("webResourceManager", new Supplier<WebResourceManager>(){

            public WebResourceManager get() {
                return ComponentAccessor.getWebResourceManager();
            }
        });
        builder.addLazy("webResourceUrlProvider", new Supplier<WebResourceUrlProvider>(){

            public WebResourceUrlProvider get() {
                return ComponentAccessor.getWebResourceUrlProvider();
            }
        });
        builder.addLazy("userformat", new Supplier<UserFormatManager>(){

            public UserFormatManager get() {
                return (UserFormatManager)ComponentAccessor.getComponentOfType(UserFormatManager.class);
            }
        });
        builder.addLazy("map", new Supplier<EasyMap>(){

            public EasyMap get() {
                return new EasyMap();
            }
        });
        builder.addLazy("atl_token", new Supplier<String>(){

            public String get() {
                return JiraVelocityUtils.getXsrfToken();
            }
        });
        builder.addLazy("keyboardShortcutManager", new Supplier<KeyboardShortcutManager>(){

            public KeyboardShortcutManager get() {
                return (KeyboardShortcutManager)ComponentAccessor.getComponentOfType(KeyboardShortcutManager.class);
            }
        });
        builder.addLazy("dateTimes", new Supplier<DateTimeVelocityUtils>(){

            public DateTimeVelocityUtils get() {
                return new DateTimeVelocityUtils(JiraVelocityUtils.dateTimeFormatter());
            }
        });
        builder.addLazy("dates", new Supplier<DateVelocityUtils>(){

            public DateVelocityUtils get() {
                return new DateVelocityUtils(JiraVelocityUtils.dateTimeFormatter());
            }
        });
        builder.addLazy("cfValueEncoder", new Supplier<Encoder>(){

            public Encoder get() {
                return (Encoder)ComponentAccessor.getComponentOfType(Encoder.class);
            }
        });
        MASTER = builder.master();
    }

    static class DateUtils
    extends com.atlassian.core.util.DateUtils {
        public DateUtils(JiraAuthenticationContext authenticationContext) {
            super(authenticationContext.getI18nHelper().getDefaultResourceBundle());
        }

        public Date date(long currentMillis) {
            return new Date(currentMillis);
        }
    }

    public static class LazyCalendar {
        private final LazyReference<Calendar> reference;
        private final ApplicationProperties applicationProperties;

        LazyCalendar(final Locale locale, ApplicationProperties applicationProperties) {
            this.applicationProperties = applicationProperties;
            this.reference = new LazyReference<Calendar>(){

                protected Calendar create() throws Exception {
                    return Calendar.getInstance(locale);
                }
            };
        }

        public int getFirstDayOfWeek() {
            return ((Calendar)this.reference.get()).getFirstDayOfWeek();
        }

        public boolean isUseISO8601() {
            return this.applicationProperties.getOption("jira.date.time.picker.use.iso8061");
        }
    }
}

