/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.event.type.EventType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.Transformer;

public class EventTypeOrderTransformer
implements Transformer {
    private Map<Long, Long> mappings;

    public EventTypeOrderTransformer() {
        long i = 1L;
        this.mappings = new HashMap<Long, Long>();
        this.mappings.put(EventType.ISSUE_CREATED_ID, i++);
        this.mappings.put(EventType.ISSUE_UPDATED_ID, i++);
        this.mappings.put(EventType.ISSUE_ASSIGNED_ID, i++);
        this.mappings.put(EventType.ISSUE_RESOLVED_ID, i++);
        this.mappings.put(EventType.ISSUE_CLOSED_ID, i++);
        this.mappings.put(EventType.ISSUE_COMMENTED_ID, i++);
        this.mappings.put(EventType.ISSUE_COMMENT_EDITED_ID, i++);
        this.mappings.put(EventType.ISSUE_COMMENT_DELETED_ID, i++);
        this.mappings.put(EventType.ISSUE_REOPENED_ID, i++);
        this.mappings.put(EventType.ISSUE_DELETED_ID, i++);
        this.mappings.put(EventType.ISSUE_MOVED_ID, i++);
        this.mappings.put(EventType.ISSUE_WORKLOGGED_ID, i++);
        this.mappings.put(EventType.ISSUE_WORKSTARTED_ID, i++);
        this.mappings.put(EventType.ISSUE_WORKSTOPPED_ID, i++);
        this.mappings.put(EventType.ISSUE_WORKLOG_UPDATED_ID, i++);
        this.mappings.put(EventType.ISSUE_WORKLOG_DELETED_ID, i++);
        this.mappings.put(EventType.ISSUE_GENERICEVENT_ID, i++);
    }

    public Object transform(Object object) {
        if (object instanceof EventType) {
            EventType eventType = (EventType)object;
            Long order = this.mappings.containsKey(eventType.getId()) ? this.mappings.get(eventType.getId()) : eventType.getId();
            return order;
        }
        return object;
    }
}

