/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericValue;

public class UserKeyStoreImpl
implements UserKeyStore {
    private static final String USER_KEY = "userKey";
    private static final String LOWER_USER_NAME = "lowerUserName";
    private final EntityEngine entityEngine;
    private final OfBizDelegator ofBizDelegator;
    private final DelegatorInterface delegatorInterface;
    private final ConcurrentMap<String, String> keyToUsernameCache = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, String> usernameToKeyCache = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, Long> userkeyToIdCache = new ConcurrentHashMap<String, Long>();

    public UserKeyStoreImpl(EntityEngine entityEngine, OfBizDelegator ofBizDelegator, DelegatorInterface delegatorInterface, EventPublisher eventPublisher) {
        this.entityEngine = entityEngine;
        this.ofBizDelegator = ofBizDelegator;
        this.delegatorInterface = delegatorInterface;
        this.buildCache();
        eventPublisher.register((Object)this);
    }

    @Override
    public String getUsernameForKey(String key) {
        if (key == null) {
            return null;
        }
        return (String)this.keyToUsernameCache.get(key);
    }

    @Override
    public String getKeyForUsername(String username) {
        if (username == null) {
            return null;
        }
        username = IdentifierUtils.toLowerCase((String)username);
        return (String)this.usernameToKeyCache.get(username);
    }

    @Override
    public Long getIdForUserKey(String userkey) {
        if (userkey == null) {
            return null;
        }
        return (Long)this.userkeyToIdCache.get(userkey);
    }

    @Override
    public void renameUser(String oldUsername, String newUsername) {
        oldUsername = IdentifierUtils.toLowerCase((String)oldUsername);
        newUsername = IdentifierUtils.toLowerCase((String)newUsername);
        String key = Select.stringColumn(USER_KEY).from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, oldUsername).runWith(this.ofBizDelegator).singleValue();
        if (key == null) {
            throw new IllegalStateException("Trying to rename user '" + oldUsername + "' but no user key is mapped.");
        }
        this.entityEngine.execute(Update.into(Entity.APPLICATION_USER).set(LOWER_USER_NAME, newUsername).whereEqual(USER_KEY, key));
        this.usernameToKeyCache.put(newUsername, key);
        this.usernameToKeyCache.remove(oldUsername);
        this.keyToUsernameCache.put(key, newUsername);
    }

    @Override
    public String ensureUniqueKeyForNewUser(String username) {
        String lowerUsername = IdentifierUtils.toLowerCase((String)((String)Assertions.notNull((String)"username", (Object)username)));
        ApplicationUserEntity applicationUserEntity = Select.from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity != null) {
            return applicationUserEntity.getKey();
        }
        applicationUserEntity = Select.from(Entity.APPLICATION_USER).whereEqual(USER_KEY, lowerUsername).runWith(this.entityEngine).singleValue();
        if (applicationUserEntity == null) {
            FieldMap fieldValues = FieldMap.build((String)USER_KEY, (Object)lowerUsername).add(LOWER_USER_NAME, (Object)lowerUsername);
            GenericValue newGV = this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
            this.keyToUsernameCache.put(lowerUsername, lowerUsername);
            this.usernameToKeyCache.put(lowerUsername, lowerUsername);
            this.userkeyToIdCache.put(lowerUsername, newGV.getLong("id"));
            return lowerUsername;
        }
        Long id = this.delegatorInterface.getNextSeqId(Entity.APPLICATION_USER.getEntityName());
        String userkey = "ID" + id;
        FieldMap fieldValues = FieldMap.build((String)"id", (Object)id).add(USER_KEY, (Object)userkey).add(LOWER_USER_NAME, (Object)lowerUsername);
        this.ofBizDelegator.createValue(Entity.APPLICATION_USER.getEntityName(), (Map)fieldValues);
        this.keyToUsernameCache.put(userkey, lowerUsername);
        this.usernameToKeyCache.put(lowerUsername, userkey);
        this.userkeyToIdCache.put(userkey, id);
        return userkey;
    }

    @Override
    public String removeByKey(String key) {
        if (key == null) {
            return null;
        }
        Delete.from(Entity.APPLICATION_USER).whereEqual(USER_KEY, key).execute(this.entityEngine);
        this.userkeyToIdCache.remove(key);
        String username = (String)this.keyToUsernameCache.remove(key);
        if (username != null) {
            this.usernameToKeyCache.remove(username);
        }
        return username;
    }

    @Override
    public String removeByName(String username) {
        if (username == null) {
            return null;
        }
        String lowerUserName = IdentifierUtils.toLowerCase((String)username);
        Delete.from(Entity.APPLICATION_USER).whereEqual(LOWER_USER_NAME, lowerUserName).execute(this.entityEngine);
        String key = (String)this.usernameToKeyCache.remove(lowerUserName);
        if (key != null) {
            this.userkeyToIdCache.remove(key);
            this.keyToUsernameCache.remove(key);
        }
        return key;
    }

    private void buildCache() {
        List<ApplicationUserEntity> users = Select.from(Entity.APPLICATION_USER).runWith(this.entityEngine).asList();
        this.keyToUsernameCache.clear();
        this.usernameToKeyCache.clear();
        this.userkeyToIdCache.clear();
        for (ApplicationUserEntity user : users) {
            this.keyToUsernameCache.put(user.getKey(), user.getUsername());
            this.usernameToKeyCache.put(user.getUsername(), user.getKey());
            this.userkeyToIdCache.put(user.getKey(), user.getId());
        }
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.buildCache();
    }
}

