/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.applinks.api.auth.oauth.ConsumerTokenService;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.CrowdException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultUserManager
implements UserManager {
    private static final Logger log = Logger.getLogger(DefaultUserManager.class);
    private static final UserQuery<User> QUERY_ALL_USERS = new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final DirectoryManager directoryManager;
    private final UserKeyStore userKeyStore;
    private final ApplicationManager applicationManager;
    private final ApplicationProperties applicationProperties;

    public DefaultUserManager(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, DirectoryManager directoryManager, UserKeyStore userKeyStore, ApplicationManager applicationManager, ApplicationProperties applicationProperties) {
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryManager = directoryManager;
        this.userKeyStore = userKeyStore;
        this.applicationManager = applicationManager;
        this.applicationProperties = applicationProperties;
    }

    public int getTotalUserCount() {
        return this.getAllUsersFromCrowd().size();
    }

    @Nonnull
    public Collection<User> getUsers() {
        return this.getAllUsersFromCrowd();
    }

    @Nonnull
    public Collection<ApplicationUser> getAllApplicationUsers() {
        Collection<User> crowdUsers = this.getAllUsersFromCrowd();
        ArrayList<ApplicationUser> users = new ArrayList<ApplicationUser>(crowdUsers.size());
        for (User user : crowdUsers) {
            users.add((ApplicationUser)new DelegatingApplicationUser(this.userKeyStore.getKeyForUsername(user.getName()), user));
        }
        return users;
    }

    @Nonnull
    private List<User> getAllUsersFromDirectory(@Nonnull Directory directory, boolean reportDirectoryNotFound) {
        try {
            return this.directoryManager.searchUsers(directory.getId().longValue(), QUERY_ALL_USERS);
        }
        catch (DirectoryNotFoundException e) {
            if (reportDirectoryNotFound) {
                throw new OperationFailedException((Throwable)e);
            }
            return ImmutableList.of();
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Nonnull
    private Collection<User> getAllUsersFromCrowd() {
        Collection<Object> allUsers;
        long startTime = System.currentTimeMillis();
        LinkedList<Directory> activeDirectories = new LinkedList<Directory>();
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (!directory.isActive()) continue;
            activeDirectories.addFirst(directory);
        }
        if (activeDirectories.size() == 1) {
            allUsers = this.getAllUsersFromDirectory((Directory)activeDirectories.getFirst(), true);
        } else {
            HashMap<String, User> userMap = new HashMap<String, User>();
            for (Directory directory : activeDirectories) {
                for (User user : this.getAllUsersFromDirectory(directory, false)) {
                    userMap.put(IdentifierUtils.toLowerCase((String)user.getName()), user);
                }
            }
            allUsers = userMap.values();
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Found " + allUsers.size() + " users in " + (System.currentTimeMillis() - startTime) + "ms."));
        }
        return allUsers;
    }

    @Nonnull
    public Set<User> getAllUsers() {
        return Sets.newHashSet(this.getAllUsersFromCrowd());
    }

    private User getCrowdUser(String userName) {
        if (userName == null) {
            return null;
        }
        return this.crowdService.getUser(userName);
    }

    public User getUser(String userName) {
        return this.getUserObject(userName);
    }

    public User getUserObject(@Nullable String userName) {
        return this.getCrowdUser(userName);
    }

    public User findUserInDirectory(String userName, Long directoryId) {
        try {
            return this.directoryManager.findUserByName(directoryId.longValue(), userName);
        }
        catch (DirectoryNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public User getUserEvenWhenUnknown(String userName) {
        if (userName == null) {
            return null;
        }
        User user = this.getCrowdUser(userName);
        return user != null ? user : this.unknownUser(userName);
    }

    public ApplicationUser getUserByKey(String key) {
        String username = this.userKeyStore.getUsernameForKey(key);
        if (username == null) {
            return null;
        }
        User user = this.getCrowdUser(username);
        if (user == null) {
            return null;
        }
        return new DelegatingApplicationUser(key, user);
    }

    public ApplicationUser getUserByName(String username) {
        User user = this.getCrowdUser(username);
        if (user == null) {
            return null;
        }
        String key = this.userKeyStore.getKeyForUsername(username);
        if (key == null) {
            throw new IllegalStateException("User '" + username + "' exists but has no unique key mapping.");
        }
        return new DelegatingApplicationUser(key, user);
    }

    public ApplicationUser getUserByKeyEvenWhenUnknown(@Nullable String userKey) {
        if (userKey == null) {
            return null;
        }
        String userName = this.userKeyStore.getUsernameForKey(userKey);
        if (userName == null) {
            return this.unknownApplicationUser(userKey, userKey);
        }
        User user = this.getUser(userName);
        if (user == null) {
            return this.unknownApplicationUser(userKey, userName);
        }
        return new DelegatingApplicationUser(userKey, user);
    }

    public ApplicationUser getUserByNameEvenWhenUnknown(@Nullable String userName) {
        if (userName == null) {
            return null;
        }
        User user = this.getCrowdUser(userName);
        String userKey = this.userKeyStore.getKeyForUsername(userName);
        if (user == null) {
            if (userKey == null) {
                userKey = IdentifierUtils.toLowerCase((String)userName);
            }
            return this.unknownApplicationUser(userKey, userName);
        }
        if (userKey == null) {
            throw new IllegalStateException("User '" + userName + "' exists but has no unique key mapping.");
        }
        return new DelegatingApplicationUser(userKey, user);
    }

    public boolean canUpdateUser(User user) {
        if (user == null) {
            return false;
        }
        return this.userDirectoryAllowsUpdateUser(user);
    }

    public boolean canUpdateUser(ApplicationUser user) {
        return this.userDirectoryAllowsUpdateUser(user.getDirectoryUser());
    }

    public boolean canRenameUser(ApplicationUser user) {
        return this.userDirectoryAllowsRenameUser(user.getDirectoryUser()) && this.isJaacsUnusedOrRenameAllowedAnyway();
    }

    @VisibleForTesting
    boolean isJaacsUnusedOrRenameAllowedAnyway() {
        return this.applicationProperties.getOption("jira.option.user.crowd.allow.rename") || !Iterables.any((Iterable)this.applicationManager.findAll(), (Predicate)new IsExternalApplication());
    }

    public void updateUser(User user) {
        try {
            ImmutableUser.Builder builder = ImmutableUser.newUser((User)user);
            builder.emailAddress(StringUtils.trim((String)user.getEmailAddress()));
            this.crowdService.updateUser(builder.toUser());
            ComponentAccessor.getUserUtil().clearActiveUserCount();
        }
        catch (InvalidUserException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (OperationNotPermittedException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    private void handleDeletedUserEviction(String fromUsername) {
        if (this.userKeyStore.getKeyForUsername(fromUsername) == null) {
            return;
        }
        int count = 1;
        String toUsername = fromUsername + "#1";
        while (this.userKeyStore.getKeyForUsername(toUsername) != null) {
            if (count == Integer.MAX_VALUE) {
                throw new IllegalStateException("Deleted user eviction namespace exhausted");
            }
            toUsername = fromUsername + '#' + ++count;
        }
        this.userKeyStore.renameUser(fromUsername, toUsername);
    }

    private void handleRenamedUser(ApplicationUser user) {
        String oldUsername;
        String newUsername = IdentifierUtils.toLowerCase((String)user.getUsername());
        if (newUsername.equals(oldUsername = this.userKeyStore.getUsernameForKey(user.getKey()))) {
            return;
        }
        if (this.getCrowdUser(newUsername) != null) {
            throw new IllegalArgumentException("Cannot rename: user with username '" + newUsername + "' already exists.");
        }
        this.handleDeletedUserEviction(newUsername);
        try {
            this.directoryManager.renameUser(user.getDirectoryId(), oldUsername, user.getUsername());
            if (this.crowdService.getUser(oldUsername) != null) {
                this.userKeyStore.ensureUniqueKeyForNewUser(oldUsername);
            }
            this.clearConsumerTokens(oldUsername);
        }
        catch (CrowdException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (DirectoryPermissionException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    private void clearConsumerTokens(String username) {
        ConsumerTokenService consumerTokenService = (ConsumerTokenService)ComponentAccessor.getOSGiComponentInstanceOfType(ConsumerTokenService.class);
        if (consumerTokenService != null) {
            consumerTokenService.removeAllTokensForUsername(username);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Unable to clear consumer tokens for '" + username + "' because the service could not be located.  Maybe applinks is offline?"));
        }
    }

    public void updateUser(ApplicationUser user) {
        this.handleRenamedUser(user);
        try {
            this.crowdService.updateUser(user.getDirectoryUser());
            ComponentAccessor.getUserUtil().clearActiveUserCount();
        }
        catch (InvalidUserException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (OperationNotPermittedException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    public boolean canUpdateUserPassword(User user) {
        if (!this.userDirectoryAllowsUpdateUser(user)) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return this.canDirectoryUpdateUserPassword(directory);
    }

    private boolean userDirectoryAllowsUpdateUser(User user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    private boolean userDirectoryAllowsRenameUser(User user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        if (!directory.getAllowedOperations().contains(OperationType.UPDATE_USER)) {
            return false;
        }
        DirectoryType directoryType = directory.getType();
        return directoryType == DirectoryType.INTERNAL || directoryType == DirectoryType.DELEGATING;
    }

    public boolean canUpdateGroupMembershipForUser(User user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    public Collection<Group> getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        Iterable crowdGroups = this.crowdService.search((Query)query);
        if (crowdGroups instanceof Collection) {
            return (Collection)crowdGroups;
        }
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (Group group : crowdGroups) {
            groups.add(group);
        }
        return groups;
    }

    public Set<Group> getAllGroups() {
        Collection<Group> groups = this.getGroups();
        if (groups instanceof Set) {
            return (Set)groups;
        }
        return new LinkedHashSet<Group>(groups);
    }

    private Group getCrowdGroup(String groupName) {
        if (groupName == null) {
            return null;
        }
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroup(String groupName) {
        return this.getCrowdGroup(groupName);
    }

    public Group getGroupObject(@Nullable String groupName) {
        return this.getCrowdGroup(groupName);
    }

    @Nonnull
    public List<Directory> getWritableDirectories() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        ArrayList<Directory> writableDirectories = new ArrayList<Directory>(allDirectories.size());
        for (Directory directory : allDirectories) {
            if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER) || !directory.isActive()) continue;
            writableDirectories.add(directory);
        }
        return writableDirectories;
    }

    public boolean hasWritableDirectory() {
        return this.getWritableDirectories().size() > 0;
    }

    public boolean hasPasswordWritableDirectory() {
        List<Directory> writableDirectories = this.getWritableDirectories();
        for (Directory directory : writableDirectories) {
            if (!this.canDirectoryUpdateUserPassword(directory)) continue;
            return true;
        }
        return false;
    }

    public boolean hasGroupWritableDirectory() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        for (Directory directory : allDirectories) {
            if (!directory.isActive() || !directory.getAllowedOperations().contains(OperationType.CREATE_GROUP)) continue;
            return true;
        }
        return false;
    }

    public Directory getDirectory(Long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId.longValue());
    }

    public boolean isUserExisting(ApplicationUser user) {
        return user != null && user.getDirectoryId() != -1L;
    }

    public boolean canDirectoryUpdateUserPassword(Directory directory) {
        if (directory == null) {
            return false;
        }
        if (directory.getType() == DirectoryType.DELEGATING) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nullable User user) {
        if (user == null) {
            return UserManager.UserState.INVALID_USER;
        }
        return this.getUserState(((User)Assertions.notNull((String)"user", (Object)user)).getName(), user.getDirectoryId());
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nullable ApplicationUser user) {
        if (user == null) {
            return UserManager.UserState.INVALID_USER;
        }
        return this.getUserState(((ApplicationUser)Assertions.notNull((String)"user", (Object)user)).getUsername(), user.getDirectoryId());
    }

    @Nonnull
    public UserManager.UserState getUserState(@Nonnull String username, long queryDirectoryId) {
        Assertions.notNull((String)"username", (Object)username);
        if (queryDirectoryId == -1L) {
            return UserManager.UserState.INVALID_USER;
        }
        boolean foundQuery = false;
        boolean foundOther = false;
        for (Directory directory : this.crowdDirectoryService.findAllDirectories()) {
            if (queryDirectoryId == directory.getId()) {
                if (!this.isUserInDirectory(username, directory)) {
                    return UserManager.UserState.INVALID_USER;
                }
                if (foundOther) {
                    return UserManager.UserState.SHADOW_USER;
                }
                foundQuery = true;
                continue;
            }
            if (foundOther || !this.isUserInDirectory(username, directory)) continue;
            if (foundQuery) {
                return UserManager.UserState.NORMAL_USER_WITH_SHADOW;
            }
            foundOther = true;
        }
        return foundQuery ? UserManager.UserState.NORMAL_USER : UserManager.UserState.INVALID_USER;
    }

    private boolean isUserInDirectory(String userName, Directory directory) {
        return directory.isActive() && this.findUserInDirectory(userName, directory.getId()) != null;
    }

    private User unknownUser(String userNameOrKey) {
        return new ImmutableUser(-1L, userNameOrKey, userNameOrKey, "?", false);
    }

    private ApplicationUser unknownApplicationUser(String userKey, String userName) {
        return new DelegatingApplicationUser(userKey, this.unknownUser(userName));
    }

    static class IsExternalApplication
    implements Predicate<Application> {
        IsExternalApplication() {
        }

        public boolean apply(Application input) {
            return !input.isPermanent();
        }
    }
}

