/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.gadgets.GadgetRequestContextFactory;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.profile.ViewProfilePanel;
import com.atlassian.jira.plugin.profile.ViewProfilePanelModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.profile.ActivityUserProfileFragment;
import com.atlassian.jira.user.profile.PlugableUserProfileFragment;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.GroupPermissionChecker;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.VelocityParamFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.webresource.WebResourceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SummaryUserProfilePanel
implements ViewProfilePanel {
    private static final Logger log = Logger.getLogger(SummaryUserProfilePanel.class);
    private ViewProfilePanelModuleDescriptor moduleDescriptor;
    private final JiraAuthenticationContext context;
    private final SearchService searchService;
    private final I18nHelper.BeanFactory i18nFactory;
    private final FieldVisibilityManager fieldVisibiltyManager;
    private final ApplicationProperties applicationProperties;
    private final VelocityRequestContext requestContext;
    private final PlugableUserProfileFragment plugablePanel;
    private final ActivityUserProfileFragment activityUserProfileFragment;

    public SummaryUserProfilePanel(EmailFormatter emailFormatter, JiraAuthenticationContext context, PermissionManager permissionManager, GroupPermissionChecker groupPermissionChecker, SearchService searchService, VelocityRequestContextFactory velocityRequestContextFactory, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory, I18nHelper.BeanFactory i18nFactory, WebResourceManager webResourceManager, ApplicationProperties applicationProperties1, FieldVisibilityManager fieldVisibiltyManager, UserPreferencesManager preferencesManager, LocaleManager localeManager, CrowdService crowdService, UserPropertyManager userPropertyManager, AvatarManager avatarManager, UserManager userManager, TimeZoneService timeZoneManager, AvatarService avatarService, WebInterfaceManager webInterfaceManager) {
        this.context = context;
        this.searchService = searchService;
        this.i18nFactory = i18nFactory;
        this.fieldVisibiltyManager = fieldVisibiltyManager;
        this.applicationProperties = applicationProperties1;
        this.requestContext = velocityRequestContextFactory.getJiraVelocityRequestContext();
        this.activityUserProfileFragment = new ActivityUserProfileFragment(pluginAccessor, ComponentManager.getOSGiComponentInstanceOfType(GadgetRequestContextFactory.class), i18nFactory);
        this.plugablePanel = new PlugableUserProfileFragment(context, templatingEngine, velocityParamFactory, webInterfaceManager);
    }

    public void init(ViewProfilePanelModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    public String getHtml(User profileUser) {
        return this.moduleDescriptor.getHtml("view", this.getParams(profileUser));
    }

    private Map<String, Object> getParams(User profileUser) {
        User currentUser = this.context.getLoggedInUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("filters", this.getFilters(profileUser, currentUser));
        params.put("profileUser", profileUser);
        params.put("currentUser", currentUser);
        params.put("activityStreamFrag", this.activityUserProfileFragment);
        params.put("plugablePanel", this.plugablePanel);
        return params;
    }

    private List<SimpleLink> getFilters(User profileUser, User currentUser) {
        I18nHelper i18n = this.i18nFactory.getInstance(currentUser);
        boolean isResolutionAvailable = this.isResolutionFieldAvailable(currentUser);
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        links.add(this.getAssigned(profileUser, i18n));
        if (isResolutionAvailable) {
            links.add(this.getAssignedAndOpen(profileUser, i18n));
        }
        links.add(this.getInProgress(profileUser, i18n));
        links.add(this.getReported(profileUser, i18n));
        if (isResolutionAvailable) {
            links.add(this.getReportedAndOpen(profileUser, i18n));
        }
        if (profileUser.equals(currentUser)) {
            if (this.isVotingEnabled()) {
                links.add(this.getVoted(i18n));
                if (isResolutionAvailable) {
                    links.add(this.getVotedAndOpen(i18n));
                }
            }
            if (this.isWatchingEnabled()) {
                links.add(this.getWatched(i18n));
                if (isResolutionAvailable) {
                    links.add(this.getWatchedAndOpen(i18n));
                }
            }
        }
        return links;
    }

    private SimpleLink getAssignedAndOpen(User profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        User currentUser = this.context.getLoggedInUser();
        if (profileUser.equals(currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("ass_open", i18n.getText("userfilters.assigned.and.open"), i18n.getText("userfilters.assigned.and.open.desc"), null, null, null, url, null);
    }

    private SimpleLink getAssigned(User profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
        User currentUser = this.context.getLoggedInUser();
        if (profileUser.equals(currentUser)) {
            builder.assigneeIsCurrentUser();
        } else {
            builder.assignee().eq(profileUser.getName());
        }
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("ass", i18n.getText("userfilters.assigned"), i18n.getText("userfilters.assigned.desc"), null, null, null, url, null);
    }

    private SimpleLink getInProgress(User profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().status(new String[]{"3"});
        User currentUser = this.context.getLoggedInUser();
        if (profileUser.equals(currentUser)) {
            builder.and().assigneeIsCurrentUser();
        } else {
            builder.and().assignee().eq(profileUser.getName());
        }
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("ass_inprog", i18n.getText("userfilters.assigned.and.inprogress"), i18n.getText("userfilters.assigned.and.inprogress.desc"), null, null, null, url, null);
    }

    private SimpleLink getReportedAndOpen(User profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().unresolved();
        User currentUser = this.context.getLoggedInUser();
        if (profileUser.equals(currentUser)) {
            builder.and().reporterIsCurrentUser();
        } else {
            builder.and().reporter().eq(profileUser.getName());
        }
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("rep_open", i18n.getText("userfilters.reported.and.open"), i18n.getText("userfilters.reported.and.open.desc"), null, null, null, url, null);
    }

    private SimpleLink getReported(User profileUser, I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
        User currentUser = this.context.getLoggedInUser();
        if (profileUser.equals(currentUser)) {
            builder.reporterIsCurrentUser();
        } else {
            builder.reporter().eq(profileUser.getName());
        }
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("rep", i18n.getText("userfilters.reported"), i18n.getText("userfilters.reported.desc"), null, null, null, url, null);
    }

    private boolean isVotingEnabled() {
        return this.applicationProperties.getOption("jira.option.voting");
    }

    private boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    private boolean isResolutionFieldAvailable(User user) {
        return this.fieldVisibiltyManager.isFieldVisible(user, "resolution");
    }

    private SimpleLink getVoted(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInVotedIssues();
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("voted", i18n.getText("userfilters.voted"), i18n.getText("userfilters.voted.desc"), null, null, null, url, null);
    }

    private SimpleLink getVotedAndOpen(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInVotedIssues().and().unresolved();
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("voted_open", i18n.getText("userfilters.voted.and.open"), i18n.getText("userfilters.voted.and.open.desc"), null, null, null, url, null);
    }

    private SimpleLink getWatched(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInWatchedIssues();
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("watched", i18n.getText("userfilters.watched"), i18n.getText("userfilters.watched.desc"), null, null, null, url, null);
    }

    private SimpleLink getWatchedAndOpen(I18nHelper i18n) {
        JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder().issueInWatchedIssues().and().unresolved();
        String jql = this.searchService.getQueryString(this.context.getLoggedInUser(), builder.buildQuery());
        String url = this.requestContext.getBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + jql;
        return new SimpleLinkImpl("watched_open", i18n.getText("userfilters.watched.and.open"), i18n.getText("userfilters.watched.and.open.desc"), null, null, null, url, null);
    }
}

