/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.entity.EntityListConsumer;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;
import org.ofbiz.core.entity.model.ModelEntity;

public class UpgradeTask_Build6129
extends AbstractUpgradeTask {
    public static final String ISSUE_ENTITY_NAME = "Issue";
    public static final String ISSUE_TABLE_NAME = "jiraissue";
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6129.class);

    public UpgradeTask_Build6129() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "6129";
    }

    @Override
    public String getShortDescription() {
        return "Extract Issue number to a separate column";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        DateTime startedAt = new DateTime();
        Connection connection = this.getDatabaseConnection();
        try {
            connection.setAutoCommit(false);
            if (this.isPostgreSQL(connection)) {
                this.postgresUpgrade(connection);
            } else if (this.isMySql(connection)) {
                this.mysqlUpgrade(connection);
            }
            this.genericUpgrade(connection);
        }
        catch (Throwable throwable) {
            log.info((Object)String.format("Upgrade task took %d seconds to complete", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds()));
            connection.close();
            throw throwable;
        }
        log.info((Object)String.format("Upgrade task took %d seconds to complete", Seconds.secondsBetween((ReadableInstant)startedAt, (ReadableInstant)new DateTime()).getSeconds()));
        connection.close();
    }

    private Map<String, Long> getAllProjects() {
        return Select.columns("id", "key").from("Project").runWith(UpgradeTask_Build6129.getEntityEngine()).consumeWith(new ProjectConsumer());
    }

    private void postgresUpgrade(Connection connection) throws SQLException, GenericEntityException {
        this.substrUpgrade(connection, new NormalSubstrBuilder(), "INT");
    }

    private void mysqlUpgrade(Connection connection) throws SQLException, GenericEntityException {
        this.substrUpgrade(connection, new NormalSubstrBuilder(), "UNSIGNED");
    }

    private void substrUpgrade(Connection connection, SubstrBuilder substr, String castType) throws SQLException, GenericEntityException {
        ModelEntity issueTable = UpgradeTask_Build6129.getOfBizDelegator().getModelReader().getModelEntity(ISSUE_ENTITY_NAME);
        String projectColumn = issueTable.getField("project").getColName();
        String issueNumColumn = issueTable.getField("number").getColName();
        String keyColumn = issueTable.getField("key").getColName();
        Statement statement = connection.createStatement();
        for (Map.Entry<String, Long> entry : this.getAllProjects().entrySet()) {
            String projectKey = entry.getKey();
            Long projectId = entry.getValue();
            try {
                int index = projectKey.length() + 2;
                String update = "UPDATE " + this.convertToSchemaTableName(ISSUE_TABLE_NAME) + " SET " + issueNumColumn + "=CAST(" + substr.of(keyColumn, index) + " AS " + castType + "), pkey=NULL" + " WHERE " + projectColumn + '=' + projectId + " AND " + keyColumn + " IS NOT NULL";
                int updated = statement.executeUpdate(update);
                connection.commit();
                if (updated <= 0) continue;
                log.info((Object)("[" + projectKey + "] issues updated: " + updated));
            }
            catch (SQLException sqle) {
                log.warn((Object)("[" + projectKey + "] fast upgrade failed (will fall back on slow upgrade): " + sqle));
                connection.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genericUpgrade(Connection connection) throws Exception {
        try {
            long issuesInTotal = this.getIssueCount();
            log.info((Object)("Total issue count: " + issuesInTotal));
            String selectSql = "SELECT id, pkey FROM " + this.convertToSchemaTableName(ISSUE_TABLE_NAME) + " WHERE pkey IS NOT NULL ";
            PreparedStatement selectStmt = connection.prepareStatement(selectSql);
            try {
                String updateSql = "UPDATE " + this.convertToSchemaTableName(ISSUE_TABLE_NAME) + " SET issuenum = ? WHERE id = ? ";
                PreparedStatement updateStmt = connection.prepareStatement(updateSql);
                try {
                    ResultSet rs = selectStmt.executeQuery();
                    try {
                        this.genericUpgradeBatch(connection, issuesInTotal, updateStmt, rs);
                    }
                    finally {
                        rs.close();
                    }
                    updateStmt.executeBatch();
                }
                finally {
                    updateStmt.close();
                }
            }
            finally {
                selectStmt.close();
            }
            connection.commit();
        }
        catch (Exception e) {
            connection.rollback();
            throw e;
        }
    }

    private void genericUpgradeBatch(Connection connection, long issuesInTotal, PreparedStatement updateStmt, ResultSet rs) throws SQLException {
        DateTime lastReport = new DateTime();
        long processed = 0L;
        while (rs.next()) {
            String pkey = null;
            long issueNum = -1L;
            long id = -1L;
            try {
                DateTime now;
                pkey = rs.getString("pkey");
                id = rs.getLong("id");
                issueNum = this.getIssueNumberFromKey(pkey);
                updateStmt.setLong(1, issueNum);
                updateStmt.setLong(2, id);
                updateStmt.addBatch();
                if (++processed % 250L == 0L) {
                    updateStmt.executeBatch();
                    connection.commit();
                }
                if (!Seconds.secondsBetween((ReadableInstant)lastReport, (ReadableInstant)(now = new DateTime())).isGreaterThan(Seconds.seconds((int)30))) continue;
                lastReport = now;
                log.info((Object)String.format("Processed %d Issues, %d left for processing", processed, issuesInTotal - processed));
            }
            catch (SQLException sqle) {
                log.error((Object)("Update failed in batch.  Detected at processed=" + processed + "; pkey=" + pkey + "; issueNum=" + issueNum + "; id=" + id + "; sqle=" + sqle));
                for (SQLException ex = sqle.getNextException(); ex != null; ex = ex.getNextException()) {
                    log.error((Object)("Chained exception: " + ex));
                }
                throw sqle;
            }
        }
        log.info((Object)("Total issues handled row-at-a-time: " + processed));
    }

    protected long getIssueCount() {
        return Select.countFrom(ISSUE_ENTITY_NAME).runWith(UpgradeTask_Build6129.getOfBizDelegator()).singleValue();
    }

    protected long getIssueNumberFromKey(String pkey) {
        return IssueKey.from((String)pkey).getIssueNumber();
    }

    private boolean isDatabaseTypeForFieldType(Connection connection, String fieldType) {
        DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
        return databaseType.getFieldTypeName().startsWith(fieldType);
    }

    private boolean isPostgreSQL(Connection connection) {
        return this.isDatabaseTypeForFieldType(connection, "postgres");
    }

    private boolean isMySql(Connection connection) throws SQLException {
        return this.isDatabaseTypeForFieldType(connection, "mysql");
    }

    static class ProjectConsumer
    implements EntityListConsumer<GenericValue, Map<String, Long>> {
        final Map<String, Long> result = new TreeMap<String, Long>();

        ProjectConsumer() {
        }

        @Override
        public void consume(GenericValue gv) {
            this.result.put(gv.getString("key"), gv.getLong("id"));
        }

        @Override
        public Map<String, Long> result() {
            return this.result;
        }
    }

    static class NormalSubstrBuilder
    implements SubstrBuilder {
        NormalSubstrBuilder() {
        }

        @Override
        public String of(String column, int index) {
            return "SUBSTR(" + column + ',' + index + ')';
        }
    }

    static interface SubstrBuilder {
        public String of(String var1, int var2);
    }
}

