/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.util.List;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6122
extends AbstractUpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask_Build6122.class);

    public UpgradeTask_Build6122() {
        super(false);
    }

    @Override
    public String getBuildNumber() {
        return "6122";
    }

    @Override
    public String getShortDescription() {
        return "Remove the VCS Update Service, now managed inside the jira-cvs-plugin.";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        OfBizDelegator delegator = UpgradeTask_Build6122.getOfBizDelegator();
        List serviceConfigs = delegator.findByAnd("ServiceConfig", EasyMap.build((Object)"name", (Object)"VCS Update Service"));
        if (!serviceConfigs.isEmpty()) {
            if (serviceConfigs.size() > 1) {
                log.error((Object)"Should not be more than one VCS Update Service present.");
                return;
            }
            GenericValue serviceConfigGV = (GenericValue)serviceConfigs.get(0);
            log.info((Object)("Removing VCS Update Service with id: " + serviceConfigGV.getLong("id")));
            OFBizPropertyUtils.removePropertySet(serviceConfigGV);
            serviceConfigGV.remove();
            ServiceManager component = (ServiceManager)ComponentAccessor.getComponent(ServiceManager.class);
            log.info((Object)"Cleaning ServiceManager cache");
            component.refreshAll();
        }
    }
}

