/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class UpgradeTask_Build6042
extends AbstractUpgradeTask {
    private static final String USER_FEATURES = "user.features.enabled";
    private static final String SITE_FEATURES = "jira.enabled.dark.features";
    private final OfBizDelegator ofBizDelegator;
    private final JiraAuthenticationContext authContext;

    public UpgradeTask_Build6042(OfBizDelegator ofBizDelegator, JiraAuthenticationContext authContext) {
        super(false);
        this.ofBizDelegator = ofBizDelegator;
        this.authContext = authContext;
    }

    @Override
    public String getBuildNumber() {
        return "6042";
    }

    @Override
    public String getShortDescription() {
        return "Change the user and site dark features to be stored as text rather then string to allow for more then 255 characters";
    }

    @Override
    public void doUpgrade(boolean setupMode) throws Exception {
        this.ensureFeatureTableConsistent();
        this.migrateFeatures(USER_FEATURES);
        this.migrateFeatures(SITE_FEATURES);
    }

    private void migrateFeatures(String featureType) throws GenericEntityException {
        GenericValue sourcePropertyGV = this.getPropertyGV("OSPropertyEntry", "propertyKey", featureType);
        if (sourcePropertyGV != null) {
            long entityId = sourcePropertyGV.getLong("entityId");
            long id = sourcePropertyGV.getLong("id");
            GenericValue sourceFeatureGV = this.ofBizDelegator.findById("OSPropertyString", Long.valueOf(id));
            if (sourceFeatureGV != null) {
                Set<String> sourceFeatures = this.deserialize(sourceFeatureGV.getString("value"));
                sourceFeatureGV.remove();
                for (String feature : sourceFeatures) {
                    MapBuilder propertyMapBuilder = MapBuilder.newBuilder();
                    propertyMapBuilder.add((Object)"featureName", (Object)feature);
                    propertyMapBuilder.add((Object)"featureType", (Object)this.getFeatureType(featureType));
                    propertyMapBuilder.add((Object)"userKey", (Object)this.getUserKey(featureType, entityId));
                    Map featureMap = propertyMapBuilder.toMap();
                    if (!this.featureNotPresent(featureMap)) continue;
                    this.ofBizDelegator.createValue("Feature", featureMap);
                }
            }
            sourcePropertyGV.remove();
        }
    }

    private boolean featureNotPresent(Map<String, Object> featureMap) {
        List features = this.ofBizDelegator.findByAnd("Feature", featureMap);
        return features == null || features.size() == 0;
    }

    private String getFeatureType(String property) {
        return property.equals(USER_FEATURES) ? "user" : "site";
    }

    private String getUserKey(String featureType, long entityId) {
        GenericValue usergv;
        if (featureType.equals(USER_FEATURES) && (usergv = this.ofBizDelegator.findById("ApplicationUser", Long.valueOf(entityId))) != null) {
            return usergv.getString("userKey");
        }
        return null;
    }

    private GenericValue getPropertyGV(String table, String column, String value) {
        List properties = this.ofBizDelegator.findByAnd(table, (Map)ImmutableMap.of((Object)column, (Object)value));
        if (properties != null && properties.size() > 0) {
            return (GenericValue)properties.iterator().next();
        }
        return null;
    }

    private Set<String> deserialize(String features) {
        if (StringUtils.isBlank((String)features)) {
            return Sets.newHashSet();
        }
        Object[] featureKeys = features.split(",");
        return Sets.newHashSet((Object[])featureKeys);
    }

    private void ensureFeatureTableConsistent() throws GenericEntityException {
        List features = this.ofBizDelegator.findAll("Feature", (List)Lists.newArrayList((Object[])new String[]{"id"}));
        if (features != null && features.size() > 0) {
            long maxId = ((GenericValue)features.get(features.size() - 1)).getLong("id");
            this.setNextId("Feature", ++maxId);
        }
    }

    private void setNextId(String entityName, Long nextId) throws GenericEntityException {
        GenericDelegator delegator = this.getDelegator();
        delegator.getNextSeqId(entityName);
        GenericValue sequenceItem = EntityUtil.getOnly((List)delegator.findByAnd("SequenceValueItem", (Map)ImmutableMap.of((Object)"seqName", (Object)entityName)));
        if (sequenceItem != null) {
            sequenceItem.set("seqId", (Object)nextId);
            sequenceItem.store();
            delegator.refreshSequencer();
        }
    }

    private static final class Column {
        private static final String ID = "id";
        private static final String VALUE = "value";
        private static final String KEY = "propertyKey";
        private static final String ENTITY_ID = "entityId";
        private static final String FEATURE_NAME = "featureName";
        private static final String FEATURE_TYPE = "featureType";
        private static final String USERKEY = "userKey";

        private Column() {
        }
    }

    private static final class Table {
        private static final String ENTRY = "OSPropertyEntry";
        private static final String STRING = "OSPropertyString";
        private static final String FEATURE = "Feature";
        private static final String APPLICATION_USER = "ApplicationUser";

        private Table() {
        }
    }
}

