/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.upgrade.AbstractUpgradeTask;
import java.sql.Connection;
import java.sql.SQLException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public abstract class DropIndexTask
extends AbstractUpgradeTask {
    public DropIndexTask(boolean reindexRequired) {
        super(reindexRequired);
    }

    @Override
    protected Connection getDatabaseConnection() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            DatabaseUtil utils = new DatabaseUtil(helper.getHelperName());
            return utils.getConnection();
        }
        catch (SQLException e) {
            throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to obtain a DB connection", (Throwable)e);
        }
    }

    private boolean isDatabaseTypeForFieldType(Connection connection, String fieldType) {
        DatabaseType databaseType = DatabaseTypeFactory.getTypeForConnection((Connection)connection);
        return databaseType.getFieldTypeName().startsWith(fieldType);
    }

    private boolean isMSSQL(Connection connection) throws SQLException {
        return this.isDatabaseTypeForFieldType(connection, "mssql");
    }

    private boolean isMYSQL(Connection connection) throws SQLException {
        return this.isDatabaseTypeForFieldType(connection, "mysql");
    }

    protected String buildDropIndexSql(Connection connection, String schemaName, String tableName, String index) throws SQLException {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("DROP INDEX ");
        sqlBuilder.append(index);
        if (this.isMYSQL(connection) || this.isMSSQL(connection)) {
            sqlBuilder.append(" ON ");
            sqlBuilder.append(this.convertToSchemaTableName(tableName));
        }
        return sqlBuilder.toString();
    }
}

