/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.ha.PluginMessageSender;
import com.atlassian.jira.scheduler.JiraPassivatedSchedulerLauncher;
import com.atlassian.jira.scheduler.JiraSchedulerLauncher;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.upgrade.PluginUpgradeLauncher;
import com.atlassian.jira.upgrade.UpgradeLauncher;
import com.google.common.annotations.VisibleForTesting;

public class ActiveServicesLauncher
implements JiraLauncher {
    private final PluginUpgradeLauncher pluginUpgradeLauncher;
    private final UpgradeLauncher upgradeLauncher;

    public ActiveServicesLauncher() {
        this.upgradeLauncher = new UpgradeLauncher();
        this.pluginUpgradeLauncher = new PluginUpgradeLauncher();
    }

    @VisibleForTesting
    ActiveServicesLauncher(UpgradeLauncher upgradeLauncher, PluginUpgradeLauncher pluginUpgradeLauncher) {
        this.upgradeLauncher = upgradeLauncher;
        this.pluginUpgradeLauncher = pluginUpgradeLauncher;
    }

    @Override
    public void start() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isActive()) {
            this.upgradeLauncher.start();
            this.pluginUpgradeLauncher.start();
            if (clusterManager.isClustered()) {
                ((PluginMessageSender)ComponentAccessor.getComponent(PluginMessageSender.class)).activate();
            }
            this.getSchedulerLauncher().start();
        }
    }

    @Override
    public void stop() {
        this.pluginUpgradeLauncher.stop();
        this.upgradeLauncher.stop();
        this.getSchedulerLauncher().stop();
        ((PluginMessageSender)ComponentAccessor.getComponent(PluginMessageSender.class)).stop();
    }

    private JiraSchedulerLauncher getSchedulerLauncher() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isActive()) {
            return new JiraSchedulerLauncher();
        }
        return new JiraPassivatedSchedulerLauncher();
    }
}

