/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soap.axis;

import com.atlassian.jira.soap.axis.JiraAxisJavaPicoRPCProvider;
import com.atlassian.jira.util.log.OneShotLogger;
import com.atlassian.jira.web.filters.accesslog.AccessLogBuilder;
import com.atlassian.jira.web.filters.accesslog.AtlassianSessionIdUtil;
import com.google.common.collect.ImmutableList;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;

class JiraAxisSoapLog {
    private final JiraAxisJavaPicoRPCProvider picoRpcProvider;
    private Logger log = Logger.getLogger(JiraAxisSoapLog.class);
    private Logger dumpLog = Logger.getLogger((String)(this.log.getName() + "Dump"));
    private Logger errorLog = Logger.getLogger((String)"com.atlassian.jira.soap.axis");
    private OneShotLogger soapBodyAccessOneShot = new OneShotLogger(this.errorLog);
    private OneShotLogger unexpectedThrowableOneShot = new OneShotLogger(this.errorLog);
    private static final int MAX_URL_PARAM_WIDTH = 150;
    private static final String MASKED = "**masked**";
    private static final String TOOBIG = "**BIG**";
    private static final String BINARY = "**BINARY**";
    private static final ImmutableList<Class<?>> FIXED_WIDTH_CLASSES = ImmutableList.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class, Date.class, Calendar.class);

    public JiraAxisSoapLog(JiraAxisJavaPicoRPCProvider picoRpcProvider) {
        this.picoRpcProvider = picoRpcProvider;
    }

    public void logMessage(MessageContext msgContext, int httpStatusCode, long responseTimeMS) {
        try {
            OperationDesc operationDesc = msgContext.getOperation();
            if (operationDesc != null) {
                String dumpMsg;
                HttpServletRequest httpReq = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
                String operationName = operationDesc.getName();
                Message requestMessage = msgContext.getRequestMessage();
                int tokenIndex = this.picoRpcProvider.getTokenParameterIndex(operationName);
                RPCParam[] rpcParams = this.getOperationParameterValues(msgContext, requestMessage);
                String userName = null;
                String authToken = null;
                if (tokenIndex >= 0 && tokenIndex < rpcParams.length) {
                    authToken = rpcParams[tokenIndex].getValue();
                    userName = this.picoRpcProvider.resolveTokenToUserName(authToken);
                }
                if ("login".equals(operationName) && rpcParams.length > 0) {
                    userName = rpcParams[0].getValue();
                    authToken = this.getAuthTokenFromLoginResponse(msgContext);
                }
                String soapSessionId = (String)httpReq.getAttribute("jira.request.assession.id");
                if (authToken != null) {
                    soapSessionId = AtlassianSessionIdUtil.generateASESSIONID(authToken);
                }
                String soapUrlSuffix = this.makeSoapUrlSuffix(operationDesc, rpcParams, operationName, tokenIndex);
                httpReq.setAttribute("jira.rpc.soap.username", (Object)userName);
                httpReq.setAttribute("jira.rpc.soap.urlsuffix", (Object)soapUrlSuffix);
                httpReq.setAttribute("jira.rpc.soap.soap.sessionid", (Object)soapSessionId);
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)this.logInvocation(msgContext, userName, soapUrlSuffix, httpStatusCode, responseTimeMS, soapSessionId));
                }
                if (this.dumpLog.isInfoEnabled() && !StringUtils.isBlank((String)(dumpMsg = this.logInvocationData(msgContext, userName, soapUrlSuffix, httpStatusCode, responseTimeMS, soapSessionId)))) {
                    this.dumpLog.info((Object)dumpMsg);
                }
            }
        }
        catch (RuntimeException t) {
            this.logUnexpectedException(t);
        }
    }

    private String logInvocation(MessageContext msgContext, String userName, String soapUrlSuffix, int httpStatusCode, long responseTimeMS, String sessionId) {
        long responseContentLength = this.getContentLength(msgContext.getResponseMessage());
        HttpServletRequest httpReq = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String transportURL = (String)msgContext.getProperty("transport.url");
        String uniqueRequestId = (String)httpReq.getAttribute("jira.request.id");
        if (uniqueRequestId != null) {
            uniqueRequestId = "o" + uniqueRequestId;
        }
        StringBuilder url = new StringBuilder(transportURL).append("/");
        if (soapUrlSuffix.length() > 0) {
            url.append(soapUrlSuffix);
        }
        return new AccessLogBuilder(httpReq).setRequestId(uniqueRequestId).setUrl(url.toString()).setUserName(userName).setResponseContentLength(responseContentLength).setHttpStatusCode(httpStatusCode).setResponseTimeMS(responseTimeMS).setSessionId(sessionId).toApacheCombinedLogFormat();
    }

    private String logInvocationData(MessageContext msgContext, String userName, String soapUrlSuffix, int httpStatusCode, long responseTimeMS, String sessionId) {
        try {
            StringBuilder msg = new StringBuilder();
            msg.append(this.logInvocation(msgContext, userName, soapUrlSuffix, httpStatusCode, responseTimeMS, sessionId));
            msg.append("\n");
            SOAPEnvelope reqEnv = msgContext.getRequestMessage().getSOAPEnvelope();
            SOAPEnvelope resEnv = msgContext.getResponseMessage().getSOAPEnvelope();
            StringBuffer requestEnv = new StringBuffer("\tREQ : ").append(reqEnv).append("\n");
            StringBuffer responseEnv = new StringBuffer("RES : ").append(resEnv).append("\n");
            msg.append(this.indent(requestEnv));
            msg.append(this.indent(responseEnv));
            return msg.toString();
        }
        catch (AxisFault axisFault) {
            AxisFault problemE = axisFault;
            this.soapBodyAccessOneShot.error((Object)"Cant access SOAP request/response as expected", (Throwable)problemE);
            return "";
        }
    }

    private String indent(StringBuffer sb) {
        return StringUtils.replace((String)sb.toString(), (String)"\n", (String)"\n\t");
    }

    private String makeSoapUrlSuffix(OperationDesc operation, RPCParam[] rpcParams, String operationName, int tokenIndex) {
        StringBuilder parameters = new StringBuilder(operation.getName());
        for (int i = 0; i < rpcParams.length; ++i) {
            RPCParam rpcParam = rpcParams[i];
            String value = this.getLogValue(rpcParam);
            if ("login".equals(operationName) && i == 1) {
                value = MASKED;
            } else if (!"login".equals(operationName) && i == tokenIndex) {
                value = MASKED;
            }
            parameters.append(i == 0 ? "?" : "&").append(rpcParam.getName()).append("=").append(value);
            if (parameters.length() > 150) break;
        }
        return StringUtils.abbreviate((String)parameters.toString(), (int)150);
    }

    private String getLogValue(RPCParam rpcParam) {
        Object obj = rpcParam.getObjectValue();
        if (this.isFixedWidthType(obj)) {
            return rpcParam.getValue();
        }
        if (obj instanceof String) {
            String string = (String)obj;
            if (string.length() > 150) {
                return TOOBIG;
            }
            return rpcParam.getValue();
        }
        if (obj instanceof String[]) {
            String[] strings = (String[])obj;
            if (strings.length > 150) {
                return TOOBIG;
            }
            long totalLength = 0L;
            for (String s : strings) {
                if ((totalLength += (long)StringUtils.length((String)s)) <= 150L) continue;
                return TOOBIG;
            }
            return rpcParam.getValue();
        }
        return BINARY;
    }

    private boolean isFixedWidthType(Object obj) {
        for (Class cls : FIXED_WIDTH_CLASSES) {
            if (!cls.isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    private RPCParam[] getOperationParameterValues(MessageContext msgContext, Message requestMessage) {
        try {
            SOAPEnvelope reqEnv = requestMessage.getSOAPEnvelope();
            RPCElement bodyE = this.picoRpcProvider.getBody(reqEnv, msgContext);
            Vector params = bodyE.getParams();
            return params.toArray(new RPCParam[params.size()]);
        }
        catch (Exception e) {
            return new RPCParam[0];
        }
    }

    private long getContentLength(Message message) {
        try {
            return message.getContentLength();
        }
        catch (AxisFault axisFault) {
            return -1L;
        }
    }

    private String getAuthTokenFromLoginResponse(MessageContext loginOperationMsgContext) {
        try {
            NodeList loginReturn = loginOperationMsgContext.getResponseMessage().getSOAPBody().getElementsByTagName("loginReturn");
            if (loginReturn != null && loginReturn.getLength() > 0) {
                return loginReturn.item(0).getFirstChild().getNodeValue();
            }
        }
        catch (Exception unexpected) {
            this.logUnexpectedException(unexpected);
        }
        return null;
    }

    private void logUnexpectedException(Exception t) {
        this.unexpectedThrowableOneShot.error((Object)"A problem was encountered during SOAP access logging.  Ignoring it!", (Throwable)t);
    }
}

