/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.util.log.Log4jKit;
import java.util.Date;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ServiceRunner
implements Job {
    private static final Logger log = Logger.getLogger(ServiceRunner.class);
    private static final String MOCK_USER_NAME = "ServiceRunner";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.setLog4JInfo(MOCK_USER_NAME, "");
        long currentTime = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            String time;
            ServiceRunner serviceRunner = this;
            synchronized (serviceRunner) {
                time = DateUtils.ISO8601DateFormat.format(new Date(currentTime));
            }
            log.debug((Object)("ServiceRunner.runServices() Running at [" + time + "]"));
        }
        for (JiraServiceContainer service : ((ServiceManager)ComponentAccessor.getComponent(ServiceManager.class)).getServicesForExecution(currentTime)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running Service [" + service + "]"));
            }
            try {
                this.setLog4JInfo(MOCK_USER_NAME, service.getName());
                service.run();
            }
            catch (RuntimeException e) {
                log.error((Object)("An error occured while trying to run service '" + service.getName() + "'. " + e.getMessage()), (Throwable)e);
                throw new JobExecutionException((Exception)e, true);
            }
            finally {
                service.setLastRun();
                this.setLog4JInfo(MOCK_USER_NAME, "");
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Finished Running Service [" + service + "]"));
        }
    }

    private void setLog4JInfo(String userName, String serviceName) {
        Log4jKit.clearMDC();
        Log4jKit.putToMDC(userName, "", "", serviceName, "");
    }
}

