/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jelly.service.JellyService;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.services.DebugService;
import com.atlassian.jira.service.services.export.ExportService;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.index.ReplicatedIndexCleaningService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.user.util.Users;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import javax.annotation.Nullable;

public class DefaultInBuiltServiceTypes
implements InBuiltServiceTypes {
    private static final Iterable<InBuiltServiceTypes.InBuiltServiceType> IN_BUILT_SERVICE_TYPES = ImmutableSet.of((Object)new InBuiltServiceTypes.InBuiltServiceType(MailFetcherService.class, "admin.services.create.issues.from.mail"), (Object)new InBuiltServiceTypes.InBuiltServiceType(FileService.class, "admin.services.create.issues.from.local.files"), (Object)new InBuiltServiceTypes.InBuiltServiceType(DebugService.class, "admin.services.debugging.service"), (Object)new InBuiltServiceTypes.InBuiltServiceType(JellyService.class, "admin.services.jelly.service"), (Object)new InBuiltServiceTypes.InBuiltServiceType(ExportService.class, "admin.services.backup.service"), (Object)new InBuiltServiceTypes.InBuiltServiceType(ReplicatedIndexCleaningService.class, "admin.services.indexcleaner.service"), (Object[])new InBuiltServiceTypes.InBuiltServiceType[0]);
    private static final Iterable<InBuiltServiceTypes.InBuiltServiceType> ADMIN_MANAGEABLE_SERVICE_TYPES = Iterables.filter(IN_BUILT_SERVICE_TYPES, (Predicate)new Predicate<InBuiltServiceTypes.InBuiltServiceType>(){

        public boolean apply(@Nullable InBuiltServiceTypes.InBuiltServiceType input) {
            return input != null && input.getType() != null && MailFetcherService.class.isAssignableFrom(input.getType());
        }
    });
    private final PermissionManager permissionManager;

    public DefaultInBuiltServiceTypes(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public Iterable<InBuiltServiceTypes.InBuiltServiceType> all() {
        return IN_BUILT_SERVICE_TYPES;
    }

    @Override
    public Iterable<InBuiltServiceTypes.InBuiltServiceType> manageableBy(User user) {
        if (Users.isAnonymous((User)user)) {
            Collections.emptySet();
        }
        if (this.permissionManager.hasPermission(44, user)) {
            return this.all();
        }
        if (this.permissionManager.hasPermission(0, user)) {
            return ADMIN_MANAGEABLE_SERVICE_TYPES;
        }
        return Collections.emptySet();
    }
}

