/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@Internal
public class UserRoleActorFactory
implements RoleActorFactory {
    public static final String TYPE = "atlassian-user-role-actor";
    private UserFactory userFactory;
    private final UserManager userManager;

    public UserRoleActorFactory(final UserManager userManager) {
        this(new UserFactory(){

            @Override
            public ApplicationUser getUser(String userKey) {
                return userManager.getUserByKey(userKey);
            }
        }, userManager);
    }

    UserRoleActorFactory(UserFactory userFactory, UserManager userManager) {
        if (userFactory == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot be constructed without a UserFactory instance");
        }
        this.userFactory = userFactory;
        this.userManager = userManager;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String parameter) throws RoleActorDoesNotExistException {
        if (!TYPE.equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        Assertions.notNull((String)"parameter", (Object)parameter);
        ApplicationUser user = this.userFactory.getUser(parameter);
        if (user == null) {
            throw new RoleActorDoesNotExistException("User '" + parameter + "' does not exist.");
        }
        return new UserRoleActor(id, projectRoleId, projectId, user);
    }

    public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
        HashSet<RoleActor> originals = new HashSet<RoleActor>(roleActors);
        HashSet<UserRoleActor> userRoleActors = new HashSet<UserRoleActor>(roleActors.size());
        Iterator it = originals.iterator();
        while (it.hasNext()) {
            RoleActor roleActor = (RoleActor)it.next();
            if (!(roleActor instanceof UserRoleActor)) continue;
            userRoleActors.add((UserRoleActor)roleActor);
            it.remove();
        }
        if (!userRoleActors.isEmpty()) {
            if (userRoleActors.size() > 1) {
                UserRoleActor prototype = (UserRoleActor)((Object)userRoleActors.iterator().next());
                originals.add((RoleActor)new AggregateRoleActor((ProjectRoleActor)prototype, userRoleActors));
            } else {
                originals.addAll(userRoleActors);
            }
        }
        return Collections.unmodifiableSet(originals);
    }

    static interface UserFactory {
        public ApplicationUser getUser(String var1);
    }

    static class AggregateRoleActor
    extends AbstractRoleActor {
        private final Map<String, UserRoleActor> userRoleActorMap;

        private AggregateRoleActor(ProjectRoleActor prototype, Set<UserRoleActor> roleActors) {
            super(null, prototype.getProjectRoleId(), prototype.getProjectId(), null);
            HashMap<String, UserRoleActor> map = new HashMap<String, UserRoleActor>(roleActors.size());
            for (UserRoleActor userRoleActor : roleActors) {
                map.put(userRoleActor.getParameter(), userRoleActor);
            }
            this.userRoleActorMap = Collections.unmodifiableMap(map);
        }

        public boolean isActive() {
            return Iterables.all(this.userRoleActorMap.values(), (Predicate)new Predicate<UserRoleActor>(){

                public boolean apply(@Nullable UserRoleActor user) {
                    return user != null && user.isActive();
                }
            });
        }

        public boolean contains(ApplicationUser user) {
            return user != null && this.userRoleActorMap.containsKey(user.getKey()) && this.userRoleActorMap.get(user.getKey()).contains(user);
        }

        public boolean contains(User user) {
            return this.contains(ApplicationUsers.from((User)user));
        }

        public Set<User> getUsers() {
            HashSet<User> result = new HashSet<User>(this.userRoleActorMap.size());
            for (UserRoleActor roleActor : this.userRoleActorMap.values()) {
                result.addAll(roleActor.getUsers());
            }
            return Collections.unmodifiableSet(result);
        }

        public String getType() {
            return UserRoleActorFactory.TYPE;
        }
    }

    class UserRoleActor
    extends AbstractRoleActor {
        private UserRoleActor(Long id, Long projectRoleId, Long projectId, ApplicationUser user) {
            super(id, projectRoleId, projectId, user.getKey());
        }

        public String getType() {
            return UserRoleActorFactory.TYPE;
        }

        public boolean isActive() {
            return this.getUser().isActive();
        }

        public String getDescriptor() {
            return this.getAppUser().getDisplayName();
        }

        public Set<User> getUsers() {
            return CollectionBuilder.newBuilder((Object[])new User[]{this.getUser()}).asSet();
        }

        public boolean contains(ApplicationUser user) {
            return user != null && this.getParameter().equals(user.getKey());
        }

        public boolean contains(User user) {
            return this.contains(ApplicationUsers.from((User)user));
        }

        private ApplicationUser getAppUser() {
            return UserRoleActorFactory.this.userManager.getUserByKeyEvenWhenUnknown(this.getParameter());
        }

        private User getUser() {
            return UserRoleActorFactory.this.userManager.getUserByKeyEvenWhenUnknown(this.getParameter()).getDirectoryUser();
        }
    }
}

