/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.login;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdHttpAuthenticationFactory;
import com.atlassian.crowd.integration.seraph.v25.CrowdAuthenticator;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SSOSeraphAuthenticator
extends CrowdAuthenticator {
    private static final String JIRA_USER_DASHBOARD_CURRENT_PAGE = "jira.user.dashboard.current.page";

    public SSOSeraphAuthenticator() {
        this(RestCrowdHttpAuthenticationFactory.getAuthenticator());
    }

    public SSOSeraphAuthenticator(CrowdHttpAuthenticator crowdHttpAuthenticator) {
        super(crowdHttpAuthenticator);
    }

    protected void logoutUser(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute(JIRA_USER_DASHBOARD_CURRENT_PAGE);
    }

    protected Principal getUser(String username) {
        User user = this.getCrowdService().getUser(username);
        return user != null ? this.getUserManager().getUserByName(user.getName()) : null;
    }

    protected Principal refreshPrincipalObtainedFromSession(HttpServletRequest httpServletRequest, Principal principal) {
        Principal freshPrincipal = principal;
        if (principal != null && principal.getName() != null) {
            freshPrincipal = principal instanceof ApplicationUser ? this.getUserManager().getUserByKey(((ApplicationUser)principal).getKey()) : this.getUser(principal.getName());
            this.putPrincipalInSessionContext(httpServletRequest, freshPrincipal);
        }
        return freshPrincipal;
    }

    private CrowdService getCrowdService() {
        return (CrowdService)ComponentAccessor.getComponent(CrowdService.class);
    }

    private UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }
}

