/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.security.login.LoginLoggers;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.log.Log4jKit;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.seraph.auth.AuthenticationContext;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class JiraAuthenticationContextImpl
implements JiraAuthenticationContext {
    private static final ThreadLocal<Map<String, Object>> REQUEST_CACHE = new ThreadLocal<Map<String, Object>>(){

        @Override
        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };
    private final AuthenticationContext authenticationContext;
    private final I18nHelper.BeanFactory i18n;

    public static void clearRequestCache() {
        REQUEST_CACHE.remove();
    }

    public static Map<String, Object> getRequestCache() {
        return REQUEST_CACHE.get();
    }

    public JiraAuthenticationContextImpl(AuthenticationContext authenticationContext, I18nHelper.BeanFactory i18n) {
        this.authenticationContext = authenticationContext;
        this.i18n = i18n;
    }

    public User getLoggedInUser() {
        Principal principal = this.authenticationContext.getUser();
        if (principal == null) {
            return null;
        }
        if (principal instanceof ApplicationUser) {
            return ((ApplicationUser)principal).getDirectoryUser();
        }
        return this.getUserManager().getUser(principal.getName());
    }

    protected UserManager getUserManager() {
        return ComponentAccessor.getUserManager();
    }

    public boolean isLoggedInUser() {
        return this.getLoggedInUser() != null;
    }

    public ApplicationUser getUser() {
        return ApplicationUsers.from((User)this.getLoggedInUser());
    }

    public Locale getLocale() {
        return I18nBean.getLocaleFromUser(this.getLoggedInUser());
    }

    public OutlookDate getOutlookDate() {
        return ((OutlookDateManager)ComponentAccessor.getComponentOfType(OutlookDateManager.class)).getOutlookDate(this.getLocale());
    }

    public String getText(String key) {
        return this.getI18nHelper().getText(key);
    }

    public I18nHelper getI18nHelper() {
        return this.i18n.getInstance(this.getLoggedInUser());
    }

    public I18nHelper getI18nBean() {
        return this.getI18nHelper();
    }

    @Deprecated
    public void setLoggedInUser(User user) {
        this.setLoggedInUserImpl(user);
    }

    public void setLoggedInUser(ApplicationUser user) {
        this.setLoggedInUserImpl(ApplicationUsers.toDirectoryUser((ApplicationUser)user));
    }

    public void clearLoggedInUser() {
        this.setLoggedInUserImpl(null);
    }

    private void setLoggedInUserImpl(User user) {
        String userName = user == null ? null : user.getName();
        Log4jKit.putUserToMDC(userName);
        if (LoginLoggers.LOGIN_SETAUTHCTX_LOG.isDebugEnabled()) {
            LoginLoggers.LOGIN_SETAUTHCTX_LOG.debug((Object)("Setting JIRA Auth Context to be  '" + (StringUtils.isBlank((String)userName) ? "anonymous" : userName) + "'"));
        }
        if (user == null) {
            this.authenticationContext.clearUser();
        } else {
            this.authenticationContext.setUser((Principal)user);
        }
    }
}

