/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheduler;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.scheduler.SchedulerUtil;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public class JiraSchedulerLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(JiraSchedulerLauncher.class);
    protected static final SchedulerUtil schedulerUtil = new SchedulerUtil();

    @Override
    public void start() {
        try {
            this.proceedIfAllClear();
        }
        catch (RuntimeException rte) {
            log.fatal((Object)("A RuntimeException occurred during JiraSchedulerLauncher servlet context initialisation - " + rte.getMessage() + "."), (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.fatal((Object)("An Error occurred during JiraSchedulerLauncher servlet context initialisation - " + error.getMessage() + "."), (Throwable)error);
            throw error;
        }
    }

    protected void proceedIfAllClear() {
        if (this.checkAllClear()) {
            log.info((Object)"Starting the JIRA Scheduler....");
            try {
                schedulerUtil.initializeAndStart(this.getScheduler());
                log.info((Object)"JIRA Scheduler started.");
            }
            catch (SchedulerException e) {
                log.error((Object)"Error starting scheduler", (Throwable)e);
            }
        }
    }

    protected boolean checkAllClear() {
        boolean ok = false;
        if (!JiraStartupChecklist.startupOK()) {
            log.info((Object)"JIRA Scheduler not started: JIRA startup checklist failed.");
        } else if (!this.thereAreNoJohnsonEvents()) {
            log.info((Object)"JIRA Scheduler not started: Johnson events detected.");
        } else if (!this.canCreateScheduler()) {
            log.info((Object)"JIRA Scheduler not started: JIRA not setup yet.");
        } else {
            ok = true;
        }
        return ok;
    }

    private boolean thereAreNoJohnsonEvents() {
        JohnsonEventContainer cont = JohnsonEventContainer.get((ServletContext)ServletContextProvider.getServletContext());
        return cont.getEvents().isEmpty();
    }

    protected boolean canCreateScheduler() {
        return ComponentAccessor.getApplicationProperties().getString("jira.setup") != null;
    }

    @Override
    public void stop() {
        try {
            Scheduler scheduler = this.getScheduler();
            if (scheduler != null) {
                schedulerUtil.shutdownScheduler(scheduler);
            }
        }
        catch (SchedulerException e) {
            log.error((Object)"Error stopping scheduler", (Throwable)e);
        }
    }

    protected Scheduler getScheduler() throws SchedulerException {
        return (Scheduler)ComponentAccessor.getComponent(Scheduler.class);
    }
}

