/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.propertyset.DefaultJiraCachingPropertySetManager;
import com.atlassian.jira.propertyset.JiraCachingPropertySet;
import com.atlassian.jira.propertyset.JiraCachingPropertySetManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Maps;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.util.HashMap;
import org.apache.commons.lang3.Validate;

public class DefaultJiraPropertySetFactory
implements JiraPropertySetFactory {
    private static final Long DEFAULT_ENTITY_ID = 1L;
    private final OfBizConnectionFactory ofBizConnectionFactory;
    private final JiraCachingPropertySetManager jiraCachingPropertySetManager;

    @Deprecated
    public DefaultJiraPropertySetFactory() {
        this(new DefaultJiraCachingPropertySetManager());
    }

    public DefaultJiraPropertySetFactory(JiraCachingPropertySetManager jiraCachingPropertySetManager) {
        Validate.notNull((Object)jiraCachingPropertySetManager);
        this.jiraCachingPropertySetManager = jiraCachingPropertySetManager;
        this.ofBizConnectionFactory = DefaultOfBizConnectionFactory.getInstance();
    }

    public PropertySet buildNoncachingPropertySet(String entityName) {
        return this.buildNoncachingPropertySet(entityName, DEFAULT_ENTITY_ID);
    }

    public PropertySet buildNoncachingPropertySet(String entityName, Long entityId) {
        HashMap ofbizArgs = MapBuilder.newBuilder().add((Object)"delegator.name", (Object)this.ofBizConnectionFactory.getDelegatorName()).add((Object)"entityName", (Object)entityName).add((Object)"entityId", (Object)entityId).toHashMap();
        return this.createPropertySet("ofbiz", ofbizArgs);
    }

    public PropertySet buildCachingDefaultPropertySet(String entityName, boolean bulkLoad) {
        return this.buildCachingPropertySet(this.buildNoncachingPropertySet(entityName), bulkLoad);
    }

    public PropertySet buildCachingPropertySet(String entityName, Long entityId, boolean bulkLoad) {
        return this.buildCachingPropertySet(this.buildNoncachingPropertySet(entityName, entityId), bulkLoad);
    }

    public PropertySet buildCachingPropertySet(PropertySet propertySet, boolean bulkLoad) {
        Assertions.notNull((String)"propertySet is a required parameter", (Object)propertySet);
        HashMap arguments = MapBuilder.newBuilder().add((Object)"PropertySet", (Object)propertySet).add((Object)"bulkload", (Object)bulkLoad).toHashMap();
        PropertySet cachingPropertySet = this.createPropertySet("cached", arguments);
        if (cachingPropertySet instanceof JiraCachingPropertySet) {
            this.jiraCachingPropertySetManager.register((JiraCachingPropertySet)cachingPropertySet);
        }
        return cachingPropertySet;
    }

    public PropertySet buildMemoryPropertySet(String entityName, Long entityId) {
        PropertySet dbPropertySet = this.buildNoncachingPropertySet(entityName, entityId);
        PropertySet memoryPropertySet = this.createPropertySet("memory", Maps.newHashMap());
        PropertySetManager.clone((PropertySet)dbPropertySet, (PropertySet)memoryPropertySet);
        return memoryPropertySet;
    }

    PropertySet createPropertySet(String propertySetDelegator, HashMap<String, Object> ofbizArgs) {
        return PropertySetManager.getInstance((String)propertySetDelegator, ofbizArgs);
    }
}

