/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.propertyset;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.propertyset.JiraCachingPropertySet;
import com.atlassian.jira.propertyset.JiraCachingPropertySetManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;

public class DefaultJiraCachingPropertySetManager
implements JiraCachingPropertySetManager {
    private final Collection<JiraCachingPropertySet> propertySets = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));

    @Override
    public void register(JiraCachingPropertySet propertySet) {
        if (propertySet != null) {
            this.propertySets.add(propertySet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        Collection<JiraCachingPropertySet> collection = this.propertySets;
        synchronized (collection) {
            for (JiraCachingPropertySet propertySet : this.propertySets) {
                propertySet.clearCache();
            }
        }
    }

    @VisibleForTesting
    Collection<JiraCachingPropertySet> getManagedPropertySets() {
        return new ArrayList<JiraCachingPropertySet>(this.propertySets);
    }
}

