/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.renderer;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.FullHtmlProjectDescriptionRenderer;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.project.renderer.WikiMarkupProjectDescriptionRenderer;
import com.atlassian.util.concurrent.LazyReference;
import javax.annotation.Nonnull;

public class ProjectDescriptionRendererImpl
implements ProjectDescriptionRenderer {
    private final FeatureManager featureManager;
    private final RendererManager rendererManager;
    private final LazyReference<ProjectDescriptionRenderer> renderer = new LazyReference<ProjectDescriptionRenderer>(){

        protected ProjectDescriptionRenderer create() throws Exception {
            return ProjectDescriptionRendererImpl.this.isUseWikiMarkup() ? new WikiMarkupProjectDescriptionRenderer(ProjectDescriptionRendererImpl.this.rendererManager) : new FullHtmlProjectDescriptionRenderer();
        }
    };

    public ProjectDescriptionRendererImpl(@Nonnull FeatureManager featureManager, @Nonnull RendererManager rendererManager) {
        this.featureManager = featureManager;
        this.rendererManager = rendererManager;
    }

    @Override
    @Nonnull
    public String getViewHtml(@Nonnull Project project) {
        return this.getViewHtml(project.getDescription());
    }

    @Override
    @Nonnull
    public String getEditHtml(@Nonnull Project project) {
        return this.getEditHtml(project.getDescription());
    }

    @Override
    @Nonnull
    public String getViewHtml(@Nonnull String description) {
        return this.renderer().getViewHtml(description);
    }

    @Override
    @Nonnull
    public String getEditHtml(@Nonnull String description) {
        return this.renderer().getEditHtml(description);
    }

    @Override
    @Nonnull
    public String getDescriptionI18nKey() {
        return this.renderer().getDescriptionI18nKey();
    }

    @Nonnull
    private ProjectDescriptionRenderer renderer() {
        return (ProjectDescriptionRenderer)this.renderer.get();
    }

    @Override
    public boolean isUseWikiMarkup() {
        return this.featureManager.isOnDemand();
    }
}

