/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.util.ProjectKeyStore;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCache {
    private static final Logger log = Logger.getLogger(ProjectCache.class);
    private static final Comparator<GenericValue> PROJECT_NAME_COMPARATOR = OfBizComparators.NAME_COMPARATOR;
    private final OfBizDelegator delegator = ComponentAccessor.getOfBizDelegator();
    private final ProjectManager projectManager;
    private final ProjectKeyStore projectKeyStore;
    private volatile ImmutableMap<Long, GenericValue> projectsById;
    private volatile ImmutableMap<String, GenericValue> projectsByKey;
    private volatile ImmutableMap<String, GenericValue> projectsByKeyIgnoreCase;
    private volatile ImmutableMap<String, GenericValue> projectsByCurrentKey;
    private volatile ImmutableMap<String, GenericValue> projectsByCurrentKeyIgnoreCase;
    private volatile ImmutableSetMultimap<Long, String> projectKeys;
    private volatile ImmutableMap<Long, GenericValue> projectCategories;
    private volatile ImmutableMap<String, Long> projectToProjectCategories;
    private volatile ImmutableMap<GenericValue, List<Long>> projectCategoriesToProjects;
    private volatile ImmutableList<Long> projectsWithNoCategory;
    private volatile ImmutableList<Project> allProjectObjects;

    public ProjectCache(ProjectManager projectManager, ProjectKeyStore projectKeyStore, boolean refresh) {
        this.projectManager = projectManager;
        this.projectKeyStore = projectKeyStore;
        if (refresh) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ProjectCache.refresh");
        }
        long start = System.currentTimeMillis();
        UtilTimerStack.push((String)"ProjectCache.refresh");
        try {
            this.refreshProjectList();
            this.refreshProjectCategories();
            this.refreshCategoryProjectMappings();
            this.refreshProjectsWithNoCategory();
        }
        finally {
            UtilTimerStack.pop((String)"ProjectCache.refresh");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProjectCache.refresh took " + (System.currentTimeMillis() - start)));
        }
    }

    private void refreshProjectList() {
        ArrayList dbProjects = Lists.newArrayList((Iterable)this.projectManager.getProjects());
        Collections.sort(dbProjects, PROJECT_NAME_COMPARATOR);
        LinkedHashMap tmpById = Maps.newLinkedHashMap();
        LinkedHashMap tmpByCurrentKey = Maps.newLinkedHashMap();
        ArrayList tmpAllProjects = Lists.newArrayListWithExpectedSize((int)dbProjects.size());
        for (GenericValue projectGV : dbProjects) {
            tmpById.put(projectGV.getLong("id"), projectGV);
            tmpByCurrentKey.put(projectGV.getString("key"), projectGV);
            tmpAllProjects.add(new ProjectImpl(projectGV));
        }
        LinkedHashMap tmpByKey = Maps.newLinkedHashMap();
        HashMultimap tmpProjectKeys = HashMultimap.create((int)dbProjects.size(), (int)1);
        for (Map.Entry<String, Long> projectKey : this.projectKeyStore.getAllProjectKeys().entrySet()) {
            tmpByKey.put(projectKey.getKey(), tmpById.get(projectKey.getValue()));
            tmpProjectKeys.put((Object)projectKey.getValue(), (Object)projectKey.getKey());
        }
        this.projectsById = ImmutableMap.copyOf((Map)tmpById);
        this.projectsByKey = ImmutableMap.copyOf((Map)tmpByKey);
        this.projectsByKeyIgnoreCase = ImmutableSortedMap.copyOf(this.projectsByKey, (Comparator)String.CASE_INSENSITIVE_ORDER);
        this.projectsByCurrentKey = ImmutableMap.copyOf((Map)tmpByCurrentKey);
        this.projectsByCurrentKeyIgnoreCase = ImmutableSortedMap.copyOf(this.projectsByCurrentKey, (Comparator)String.CASE_INSENSITIVE_ORDER);
        this.allProjectObjects = ImmutableList.copyOf((Collection)tmpAllProjects);
        this.projectKeys = ImmutableSetMultimap.copyOf((Multimap)tmpProjectKeys);
    }

    protected void refreshProjectCategories() {
        List dbCategories = this.delegator.findAll("ProjectCategory");
        Collections.sort(dbCategories, PROJECT_NAME_COMPARATOR);
        LinkedHashMap<Long, GenericValue> tmpById = new LinkedHashMap<Long, GenericValue>();
        for (GenericValue projectCategory : dbCategories) {
            tmpById.put(projectCategory.getLong("id"), projectCategory);
        }
        this.projectCategories = ImmutableMap.copyOf(tmpById);
    }

    public GenericValue getProject(Long id) {
        return (GenericValue)this.projectsById.get((Object)id);
    }

    public GenericValue getProjectByName(String name) {
        for (GenericValue project : this.getProjects()) {
            if (!project.getString("name").equalsIgnoreCase(name)) continue;
            return project;
        }
        return null;
    }

    public GenericValue getProjectByKey(String key) {
        return (GenericValue)this.projectsByKey.get((Object)key);
    }

    public Collection<GenericValue> getProjects() {
        return this.projectsById.values();
    }

    public List<Project> getProjectObjects() {
        return this.allProjectObjects;
    }

    public Collection<GenericValue> getProjectCategories() {
        return this.projectCategories.values();
    }

    public GenericValue getProjectCategory(Long id) {
        return (GenericValue)this.projectCategories.get((Object)id);
    }

    private void refreshCategoryProjectMappings() {
        HashMap<String, Long> tmpProjectToProjectCategories = new HashMap<String, Long>();
        HashMap<GenericValue, List<Long>> tmpProjectCategoriesToProjects = new HashMap<GenericValue, List<Long>>();
        Collection<GenericValue> categories = this.getProjectCategories();
        if (categories != null) {
            for (GenericValue category : categories) {
                try {
                    List<GenericValue> projects = ((NodeAssociationStore)ComponentAccessor.getComponentOfType(NodeAssociationStore.class)).getSourcesFromSink(category, "Project", "ProjectCategory");
                    Collections.sort(projects, PROJECT_NAME_COMPARATOR);
                    tmpProjectCategoriesToProjects.put(category, this.getIdsFromGenericValues(projects));
                    for (GenericValue project : projects) {
                        tmpProjectToProjectCategories.put(project.getString("key"), category.getLong("id"));
                    }
                }
                catch (DataAccessException ex) {
                    log.error((Object)("Error getting projects for category " + category + ": " + (Object)((Object)ex)), (Throwable)ex);
                }
            }
        }
        this.projectToProjectCategories = ImmutableMap.copyOf(tmpProjectToProjectCategories);
        this.projectCategoriesToProjects = ImmutableMap.copyOf(tmpProjectCategoriesToProjects);
    }

    private List<Long> getIdsFromGenericValues(Collection<GenericValue> genericValues) {
        if (genericValues == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GenericValue> projectIds = new ArrayList<GenericValue>(genericValues);
        CollectionUtils.transform(projectIds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((GenericValue)object).getLong("id");
            }
        });
        return projectIds;
    }

    private List getProjectsFromProjectIds(Collection projectIds) {
        if (projectIds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList projects = new ArrayList(projectIds);
        CollectionUtils.transform(projects, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ProjectCache.this.getProject((Long)object);
            }
        });
        return projects;
    }

    public Collection getProjectsFromProjectCategory(GenericValue projectCat) {
        if (this.projectCategoriesToProjects.containsKey((Object)projectCat)) {
            return this.getProjectsFromProjectIds((Collection)this.projectCategoriesToProjects.get((Object)projectCat));
        }
        return Collections.EMPTY_LIST;
    }

    public GenericValue getProjectCategoryForProject(Project project) {
        if (project != null && this.projectToProjectCategories.containsKey((Object)project.getKey())) {
            Long projectCategoryId = (Long)this.projectToProjectCategories.get((Object)project.getKey());
            return this.getProjectCategory(projectCategoryId);
        }
        return null;
    }

    public GenericValue getProjectCategoryFromProject(GenericValue project) {
        if (project != null && this.projectToProjectCategories.containsKey((Object)project.getString("key"))) {
            Long projectId = (Long)this.projectToProjectCategories.get((Object)project.getString("key"));
            return this.getProjectCategory(projectId);
        }
        return null;
    }

    public Collection getProjectsWithNoCategory() {
        return this.getProjectsFromProjectIds((Collection)this.projectsWithNoCategory);
    }

    protected void refreshProjectsWithNoCategory() {
        ArrayList<GenericValue> projectsWithNoCategoryGVs = new ArrayList<GenericValue>();
        for (GenericValue project : this.getProjects()) {
            if (this.getProjectCategoryFromProject(project) != null) continue;
            projectsWithNoCategoryGVs.add(project);
        }
        Collections.sort(projectsWithNoCategoryGVs, PROJECT_NAME_COMPARATOR);
        this.projectsWithNoCategory = ImmutableList.copyOf(this.getIdsFromGenericValues(projectsWithNoCategoryGVs));
    }

    public GenericValue getProjectByCurrentKeyIgnoreCase(String projectKey) {
        return (GenericValue)this.projectsByCurrentKeyIgnoreCase.get((Object)projectKey);
    }

    public GenericValue getProjectByKeyIgnoreCase(String projectKey) {
        return (GenericValue)this.projectsByKeyIgnoreCase.get((Object)projectKey);
    }

    public GenericValue getProjectByCurrentKey(String projectKey) {
        return (GenericValue)this.projectsByCurrentKey.get((Object)projectKey);
    }

    public Set<String> getAllProjectKeys(Long projectId) {
        return this.projectKeys.get((Object)projectId);
    }
}

