/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.util.UserAgentUtil;
import com.atlassian.jira.util.UserAgentUtilImpl;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class JiraWebResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    public static final String PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING = "plugin.webresource.batch.content.tracking".toString();
    private static final String USER_AGENT = "USER-AGENT";
    private static final boolean DEV_MODE = JiraSystemProperties.isDevMode();
    private static final boolean SUPER_BATCHING_DISABLED = JiraSystemProperties.isSuperBatchingDisabled();
    private static final String WEB_RESOURCE_BATCHING_OFF = System.getProperty("plugin.webresource.batching.off");
    private static final String JAVASCRIPT_TRY_CATCH_WRAPPING_SETTING = System.getProperty("plugin.webresource.javascript.try.catch.wrapping");
    private static final String TRACKING_SETTING = System.getProperty(PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING);
    private static final List<String> resources = new ArrayList<String>();

    public boolean isSuperBatchingEnabled() {
        return !resources.isEmpty() && !SUPER_BATCHING_DISABLED || this.forceBatchingInThisRequest();
    }

    public boolean isContextBatchingEnabled() {
        return !DEV_MODE || this.forceBatchingInThisRequest();
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        boolean enabled = WEB_RESOURCE_BATCHING_OFF != null ? !Boolean.parseBoolean(WEB_RESOURCE_BATCHING_OFF) : !DEV_MODE;
        return enabled || this.forceBatchingInThisRequest();
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return resources;
    }

    public boolean isJavaScriptTryCatchWrappingEnabled() {
        return JAVASCRIPT_TRY_CATCH_WRAPPING_SETTING != null && Boolean.parseBoolean(JAVASCRIPT_TRY_CATCH_WRAPPING_SETTING);
    }

    public boolean isBatchContentTrackingEnabled() {
        return TRACKING_SETTING != null && Boolean.parseBoolean(TRACKING_SETTING);
    }

    public boolean resplitMergedContextBatchesForThisRequest() {
        return this.isCurrentRequestIE();
    }

    private boolean forceBatchingInThisRequest() {
        return DEV_MODE && this.isCurrentRequestIE();
    }

    private boolean isCurrentRequestIE() {
        HttpServletRequest httpRequest = ExecutingHttpRequest.get();
        if (httpRequest == null) {
            return false;
        }
        String userAgent = httpRequest.getHeader(USER_AGENT);
        UserAgentUtilImpl userAgentUtil = new UserAgentUtilImpl();
        UserAgentUtil.UserAgent userAgentInfo = userAgentUtil.getUserAgentInfo(userAgent);
        return userAgentInfo.getBrowser().getBrowserFamily().equals((Object)UserAgentUtil.BrowserFamily.MSIE);
    }

    static {
        resources.add("jira.webresources:superbatch-default");
    }
}

