/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.user.PreDeleteUserErrors;
import com.atlassian.jira.plugin.user.PreDeleteUserErrorsManager;
import com.atlassian.jira.plugin.user.PreDeleteUserErrorsModuleDescriptor;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class PreDeleteUserErrorsManagerImpl
implements PreDeleteUserErrorsManager {
    private final PluginModuleTracker<PreDeleteUserErrors, PreDeleteUserErrorsModuleDescriptor> deleteUserPluginTracker;
    private static final Logger log = Logger.getLogger(PreDeleteUserErrorsManagerImpl.class);

    public PreDeleteUserErrorsManagerImpl(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.deleteUserPluginTracker = this.createTracker(pluginAccessor, pluginEventManager);
    }

    @VisibleForTesting
    PluginModuleTracker<PreDeleteUserErrors, PreDeleteUserErrorsModuleDescriptor> createTracker(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        return DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, PreDeleteUserErrorsModuleDescriptor.class);
    }

    @VisibleForTesting
    Iterable<PreDeleteUserErrors> enabledModules() {
        return Iterables.filter((Iterable)this.deleteUserPluginTracker.getModules(), (Predicate)new Predicate<PreDeleteUserErrors>(){

            public boolean apply(@Nullable PreDeleteUserErrors input) {
                return input != null;
            }
        });
    }

    @Override
    public ImmutableList<WebErrorMessage> getWarnings(User user) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (PreDeleteUserErrors module : this.enabledModules()) {
            try {
                List moduleErrors = module.getPreDeleteUserErrors(user);
                if (moduleErrors == null) continue;
                result.addAll((Iterable)moduleErrors);
            }
            catch (RuntimeException e) {
                log.error((Object)("Unexpected error while checking delete conditions for user: " + user.getName()), (Throwable)e);
            }
        }
        return result.build();
    }
}

