/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.plugin.user.PasswordPolicy;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.PasswordPolicyModuleDescriptor;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class PasswordPolicyManagerImpl
implements PasswordPolicyManager {
    private final PluginModuleTracker<PasswordPolicy, PasswordPolicyModuleDescriptor> passwordPolicyPluginTracker;
    private static final Logger log = Logger.getLogger(PasswordPolicyManagerImpl.class);

    public PasswordPolicyManagerImpl(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.passwordPolicyPluginTracker = this.createTracker(pluginAccessor, pluginEventManager);
    }

    @Override
    @Nonnull
    public Collection<WebErrorMessage> checkPolicy(@Nonnull ApplicationUser user, @Nullable String oldPassword, @Nonnull String newPassword) {
        return this.checkPolicy(((ApplicationUser)Assertions.notNull((String)"user", (Object)user)).getDirectoryUser(), oldPassword, newPassword);
    }

    @Override
    @Nonnull
    public Collection<WebErrorMessage> checkPolicy(@Nonnull String username, @Nullable String displayName, @Nullable String emailAddress, @Nonnull String newPassword) {
        ImmutableUser template = new ImmutableUser(-1L, username, displayName, emailAddress, false);
        return this.checkPolicy((User)template, null, newPassword);
    }

    @Override
    @Nonnull
    public List<String> getPolicyDescription(boolean hasOldPassword) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (PasswordPolicy module : this.enabledModules()) {
            try {
                List advice = module.getPolicyDescription(hasOldPassword);
                if (advice == null) continue;
                result.addAll((Iterable)advice);
            }
            catch (RuntimeException e) {
                log.error((Object)"Unexpected error while building password policy description", (Throwable)e);
            }
        }
        return result.build();
    }

    @VisibleForTesting
    PluginModuleTracker<PasswordPolicy, PasswordPolicyModuleDescriptor> createTracker(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        return DefaultPluginModuleTracker.create((PluginAccessor)pluginAccessor, (PluginEventManager)pluginEventManager, PasswordPolicyModuleDescriptor.class);
    }

    @VisibleForTesting
    Iterable<PasswordPolicy> enabledModules() {
        return Iterables.filter((Iterable)this.passwordPolicyPluginTracker.getModules(), (Predicate)new Predicate<PasswordPolicy>(){

            public boolean apply(@Nullable PasswordPolicy input) {
                return input != null;
            }
        });
    }

    private Collection<WebErrorMessage> checkPolicy(@Nonnull User user, @Nullable String oldPassword, @Nonnull String newPassword) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (PasswordPolicy module : this.enabledModules()) {
            try {
                Collection moduleErrors = module.validatePolicy(user, oldPassword, newPassword);
                if (moduleErrors == null) continue;
                result.addAll((Iterable)moduleErrors);
            }
            catch (RuntimeException e) {
                log.error((Object)("Unexpected error while checking password policies for user: " + user.getName()), (Throwable)e);
            }
        }
        return result.build();
    }
}

