/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.statistics.StatsGroup;
import com.atlassian.jira.issue.statistics.util.OneDimensionalDocIssueHitCollector;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Collector;

public class SingleLevelGroupByReport
extends AbstractReport {
    private static final Logger log = Logger.getLogger(SingleLevelGroupByReport.class);
    private final SearchProvider searchProvider;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchRequestService searchRequestService;
    private final IssueFactory issueFactory;
    private final CustomFieldManager customFieldManager;
    private final IssueIndexManager issueIndexManager;
    private final SearchService searchService;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final ReaderCache readerCache;

    public SingleLevelGroupByReport(SearchProvider searchProvider, JiraAuthenticationContext authenticationContext, SearchRequestService searchRequestService, IssueFactory issueFactory, CustomFieldManager customFieldManager, IssueIndexManager issueIndexManager, SearchService searchService, FieldVisibilityManager fieldVisibilityManager, ReaderCache readerCache) {
        this.searchProvider = searchProvider;
        this.authenticationContext = authenticationContext;
        this.searchRequestService = searchRequestService;
        this.issueFactory = issueFactory;
        this.customFieldManager = customFieldManager;
        this.issueIndexManager = issueIndexManager;
        this.searchService = searchService;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.readerCache = readerCache;
    }

    public StatsGroup getOptions(SearchRequest sr, User user, StatisticsMapper mapper) throws PermissionException {
        try {
            return this.searchMapIssueKeys(sr, user, mapper);
        }
        catch (SearchException e) {
            log.error((Object)("Exception rendering " + ((Object)((Object)this)).getClass().getName() + ".  Exception " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatsGroup searchMapIssueKeys(SearchRequest request, User searcher, StatisticsMapper mapper) throws SearchException {
        try {
            UtilTimerStack.push((String)"Search Count Map");
            StatsGroup statsGroup = new StatsGroup(mapper);
            OneDimensionalDocIssueHitCollector hitCollector = new OneDimensionalDocIssueHitCollector(mapper.getDocumentConstant(), statsGroup, this.issueIndexManager.getIssueSearcher().getIndexReader(), this.issueFactory, this.fieldVisibilityManager, this.readerCache);
            this.searchProvider.searchAndSort(request != null ? request.getQuery() : null, searcher, (Collector)hitCollector, PagerFilter.getUnlimitedFilter());
            StatsGroup statsGroup2 = statsGroup;
            return statsGroup2;
        }
        finally {
            UtilTimerStack.pop((String)"Search Count Map");
        }
    }

    public String generateReportHtml(ProjectActionSupport action, Map params) throws Exception {
        String filterId = (String)params.get("filterid");
        if (filterId == null) {
            log.error((Object)("Single Level Group By Report run without a project selected (JRA-5042): params=" + params));
            return "<span class='errMsg'>No search filter has been selected. Please <a href=\"IssueNavigator.jspa?reset=Update&amp;pid=" + TextUtils.htmlEncode((String)((String)params.get("selectedProjectId"))) + "\">create one</a>, and re-run this report. See also " + "<a href=\"http://jira.atlassian.com/browse/JRA-5042\">JRA-5042</a></span>";
        }
        String mapperName = (String)params.get("mapper");
        StatisticsMapper mapper = new FilterStatisticsValuesGenerator().getStatsMapper(mapperName);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.authenticationContext.getLoggedInUser());
        SearchRequest request = this.searchRequestService.getFilter((JiraServiceContext)ctx, new Long(filterId));
        try {
            Map startingParams = EasyMap.build((Object[])new Object[]{"action", action, "statsGroup", this.getOptions(request, this.authenticationContext.getLoggedInUser(), mapper), "searchRequest", request, "mapperType", mapperName, "customFieldManager", this.customFieldManager, "fieldVisibility", new FieldVisibilityBean(), "searchService", this.searchService, "portlet", this});
            return this.descriptor.getHtml("view", startingParams);
        }
        catch (PermissionException e) {
            log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public void validate(ProjectActionSupport action, Map params) {
        super.validate(action, params);
        String filterId = (String)params.get("filterid");
        if (StringUtils.isEmpty((String)filterId)) {
            action.addError("filterid", action.getText("report.singlelevelgroupby.filter.is.required"));
        } else {
            this.validateFilterId(action, filterId);
        }
    }

    private void validateFilterId(ProjectActionSupport action, String filterId) {
        try {
            JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(action.getLoggedInUser(), (ErrorCollection)new SimpleErrorCollection());
            SearchRequest searchRequest = this.searchRequestService.getFilter((JiraServiceContext)serviceContext, new Long(filterId));
            if (searchRequest == null) {
                action.addErrorMessage(action.getText("report.error.no.filter"));
            }
        }
        catch (NumberFormatException nfe) {
            action.addError("filterId", action.getText("report.error.filter.id.not.a.number", filterId));
        }
    }
}

