/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.Collections;
import java.util.List;

public class LastLoginFunction
extends AbstractJqlFunction {
    public static final String FUNCTION_LAST_LOGIN = "lastLogin";
    private final LoginService loginService;

    public LastLoginFunction(LoginService loginService) {
        this.loginService = loginService;
    }

    public MessageSet validate(User searcher, FunctionOperand operand, TerminalClause terminalClause) {
        return this.validateNumberOfArgs(operand, 0);
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.DATE;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        if (queryCreationContext == null || queryCreationContext.getQueryUser() == null) {
            return Collections.emptyList();
        }
        User user = queryCreationContext.getQueryUser();
        if (user != null) {
            LoginInfo loginInfo = this.loginService.getLoginInfo(user.getName());
            Long previousLoginTime = loginInfo.getPreviousLoginTime();
            if (previousLoginTime != null) {
                return Collections.singletonList(new QueryLiteral((Operand)operand, previousLoginTime));
            }
            return Collections.singletonList(new QueryLiteral((Operand)operand, Long.valueOf(0L)));
        }
        return Collections.emptyList();
    }
}

