/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.plugin.ha.MessageEventRegistry;
import com.atlassian.jira.plugin.ha.PluginOperation;
import com.atlassian.jira.plugin.ha.PluginSyncService;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultPluginSyncService
implements PluginSyncService {
    private final MessageEventRegistry eventRegistry;
    private final EventPublisher eventPublisher;

    public DefaultPluginSyncService(MessageEventRegistry eventRegistry, EventPublisher eventPublisher) {
        this.eventRegistry = eventRegistry;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void syncPlugins(@Nonnull List<ClusterMessage> pluginMessages) {
        List operations = Lists.transform(pluginMessages, (Function)new Function<ClusterMessage, PluginOperation>(){

            public PluginOperation apply(@Nullable ClusterMessage input) {
                if (input == null) {
                    return null;
                }
                return new PluginOperation(input);
            }
        });
        if (!operations.isEmpty()) {
            this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
            this.firePluginEvents(operations);
        }
    }

    private void firePluginEvents(List<PluginOperation> filteredOperations) {
        for (PluginOperation operation : filteredOperations) {
            String completeKey = operation.getCompleteKey();
            Function<String, Void> eventFunction = this.eventRegistry.getEventFunction(operation.getPluginEventType());
            eventFunction.apply((Object)completeKey);
        }
    }
}

