/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import org.apache.log4j.Logger;

public class DefaultComponentClassManager
implements ComponentClassManager {
    private static final Logger log = Logger.getLogger(DefaultComponentClassManager.class);
    private final PluginAccessor pluginAccessor;
    private final PluginsClassLoader pluginsClassLoader;

    public DefaultComponentClassManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
        this.pluginsClassLoader = (PluginsClassLoader)pluginAccessor.getClassLoader();
    }

    public <T> T newInstance(String className) throws ClassNotFoundException {
        try {
            Class clazz = ClassLoaderUtils.loadClass((String)className, this.getClass());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Class '" + className + "' loaded with the standard ClassLoader " + this.getClass().getClassLoader()));
            }
            return JiraUtils.loadComponent(clazz);
        }
        catch (ClassNotFoundException ex) {
            try {
                Class clazz = this.pluginsClassLoader.loadClass(className);
                Plugin plugin = this.getPluginForClass(className);
                try {
                    return this.newInstanceFromPlugin(clazz, plugin);
                }
                catch (RuntimeException ex2) {
                    log.debug((Object)("Unable to dependency inject '" + className + "' in plugin '" + plugin.getKey() + "'. Attempting to wire it via brute force..."));
                    return (T)this.bruteForceWireInstance(className);
                }
            }
            catch (ClassNotFoundException ex2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Class '" + className + "' could not be loaded with the PluginsClassLoader - maybe it belongs to a plugin that is not enabled yet."));
                }
                return this.constructEvenIfNotEnabled(className);
            }
        }
    }

    private Object bruteForceWireInstance(String className) {
        for (Plugin plugin : this.pluginAccessor.getEnabledPlugins()) {
            try {
                Class<?> clazz = plugin.getClassLoader().loadClass(className);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Class '" + className + "' loaded from plugin " + plugin.getKey() + " - attempting to instantiate with dependencies..."));
                }
                Object o = this.newInstanceFromPlugin(clazz, plugin);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Wired Class '" + className + "' successfully from plugin " + plugin.getKey() + " ."));
                }
                return o;
            }
            catch (Exception autowireException) {
            }
        }
        throw new RuntimeException("Class '" + className + "' is loadable from OSGi but no enabled plugins could autowire an instance.");
    }

    public <T> T newInstanceFromPlugin(Class<T> clazz, Plugin plugin) {
        String className = clazz.getName();
        if (plugin instanceof AutowireCapablePlugin) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Class '" + className + "' loaded with the PluginsClassLoader - attempting autowire with plugin " + plugin.getKey()));
            }
            return (T)((AutowireCapablePlugin)plugin).autowire(clazz);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loaded the class '" + className + "' via PluginsClassLoader but plugin '" + plugin.getKey() + "' is not an AutowireCapablePlugin."));
        }
        return JiraUtils.loadComponent(clazz);
    }

    private <T> T constructEvenIfNotEnabled(String className) throws ClassNotFoundException {
        for (Plugin plugin : this.pluginAccessor.getPlugins()) {
            try {
                Class<?> clazz = plugin.getClassLoader().loadClass(className);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Class '" + className + "' loaded from plugin " + plugin.getKey() + " but this plugin was not enabled, trying to load via Pico."));
                }
                return (T)JiraUtils.loadComponent(clazz);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (ClassCastException ex) {
            }
        }
        throw new ClassNotFoundException("Class '" + className + "' not found.");
    }

    public <T> Class<T> loadClass(String className) throws ClassNotFoundException {
        try {
            return ClassLoaderUtils.loadClass((String)className, (ClassLoader)this.pluginsClassLoader);
        }
        catch (ClassNotFoundException e) {
            return this.loadClassEvenIfNotEnabled(className);
        }
    }

    private <T> Class<T> loadClassEvenIfNotEnabled(String className) throws ClassNotFoundException {
        for (Plugin plugin : this.pluginAccessor.getPlugins()) {
            try {
                return plugin.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException ex) {
            }
            catch (ClassCastException ex) {
            }
        }
        throw new ClassNotFoundException("Class '" + className + "' not found.");
    }

    private Plugin getPluginForClass(String className) {
        return this.pluginsClassLoader.getPluginForClass(className);
    }
}

