/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification.type;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.notification.type.AbstractNotificationType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class CurrentReporter
extends AbstractNotificationType {
    private static final Logger log = Logger.getLogger(CurrentReporter.class);
    private JiraAuthenticationContext jiraAuthenticationContext;

    public CurrentReporter(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public List<NotificationRecipient> getRecipients(IssueEvent event, String argument) {
        Issue issue = event.getIssue();
        if (issue != null) {
            ApplicationUser user = ComponentAccessor.getUserManager().getUserByKey(issue.getReporterId());
            String level = (String)event.getParams().get("level");
            if (user != null && (level == null || this.userInGroup(user, level))) {
                return EasyList.build((Object)new NotificationRecipient(user));
            }
            return Collections.emptyList();
        }
        log.error((Object)("Error getting reporter notification recipients - no issue associated with event: " + event.getEventTypeId()));
        return Collections.emptyList();
    }

    private boolean userInGroup(ApplicationUser user, String groupName) {
        return ComponentAccessor.getGroupManager().isUserInGroup(user.getUsername(), groupName);
    }

    @Override
    public String getDisplayName() {
        return this.jiraAuthenticationContext.getI18nHelper().getText("admin.notification.types.reporter");
    }
}

