/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.JiraKeyUtils;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class TemplateIssue
implements Issue {
    private static final Logger log = Logger.getLogger(TemplateIssue.class);
    private final Issue issue;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final CustomFieldManager customFieldManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private AggregateTimeTrackingBean aggregateBean;

    public TemplateIssue(Issue issue, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, CustomFieldManager customFieldManager, JiraDurationUtils jiraDurationUtils, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory) {
        this.issue = issue;
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
        this.customFieldManager = customFieldManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
    }

    public Long getId() {
        return this.issue.getId();
    }

    public GenericValue getProject() {
        return this.issue.getProject();
    }

    public Project getProjectObject() {
        return this.issue.getProjectObject();
    }

    public Long getProjectId() {
        return this.issue.getProjectId();
    }

    public GenericValue getIssueType() {
        return this.issue.getIssueType();
    }

    public IssueType getIssueTypeObject() {
        return this.issue.getIssueTypeObject();
    }

    public String getIssueTypeId() {
        return this.issue.getIssueTypeId();
    }

    public String getSummary() {
        return this.issue.getSummary();
    }

    public User getAssignee() {
        return this.issue.getAssignee();
    }

    public String getAssigneeId() {
        return this.issue.getAssigneeId();
    }

    public User getAssigneeUser() {
        return this.issue.getAssigneeUser();
    }

    public Collection<GenericValue> getComponents() {
        return this.issue.getComponents();
    }

    public Collection<ProjectComponent> getComponentObjects() {
        return this.issue.getComponentObjects();
    }

    public User getReporter() {
        return this.issue.getReporter();
    }

    public String getReporterId() {
        return this.issue.getReporterId();
    }

    public User getReporterUser() {
        return this.issue.getReporterUser();
    }

    public String getDescription() {
        return this.issue.getDescription();
    }

    public String getHtmlDescription() {
        try {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.issue);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("description");
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String renderedContent = this.rendererManager.getRenderedContent(rendererType, this.issue.getDescription(), this.issue.getIssueRenderContext());
            return renderedContent.replaceAll("<p>", "<p style='margin-top:0;margin-bottom:10px;'>");
        }
        catch (Exception e) {
            log.warn((Object)("Unable to produce rendered version of the description for the issue " + this.issue.getKey()), (Throwable)e);
            return JiraKeyUtils.linkBugKeys((String)this.issue.getDescription());
        }
    }

    public String getEnvironment() {
        return this.issue.getEnvironment();
    }

    public String getHtmlEnvironment() {
        try {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(this.issue);
            FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem("environment");
            String rendererType = fieldLayoutItem != null ? fieldLayoutItem.getRendererType() : null;
            String renderedContent = this.rendererManager.getRenderedContent(rendererType, this.issue.getEnvironment(), this.issue.getIssueRenderContext());
            return renderedContent.replaceAll("<p>", "<p style='margin-top:0;margin-bottom:10px;'>");
        }
        catch (Exception e) {
            log.warn((Object)("Unable to produce rendered version of the environment for the issue " + this.issue.getKey()), (Throwable)e);
            return JiraKeyUtils.linkBugKeys((String)this.issue.getEnvironment());
        }
    }

    public Collection<Version> getAffectedVersions() {
        return this.issue.getAffectedVersions();
    }

    public Collection<Version> getFixVersions() {
        return this.issue.getFixVersions();
    }

    public Timestamp getDueDate() {
        return this.issue.getDueDate();
    }

    public GenericValue getSecurityLevel() {
        return this.issue.getSecurityLevel();
    }

    public Long getSecurityLevelId() {
        return this.issue.getSecurityLevelId();
    }

    public GenericValue getPriority() {
        return this.issue.getPriority();
    }

    public Priority getPriorityObject() {
        return this.issue.getPriorityObject();
    }

    public String getResolutionId() {
        return this.issue.getResolutionId();
    }

    public GenericValue getResolution() {
        return this.issue.getResolution();
    }

    public Resolution getResolutionObject() {
        return this.issue.getResolutionObject();
    }

    public String getKey() {
        return this.issue.getKey();
    }

    public Long getNumber() {
        return this.issue.getNumber();
    }

    public Long getVotes() {
        return this.issue.getVotes();
    }

    public Long getWatches() {
        return this.issue.getWatches();
    }

    public Timestamp getCreated() {
        return this.issue.getCreated();
    }

    public Timestamp getResolutionDate() {
        return this.issue.getResolutionDate();
    }

    public Timestamp getUpdated() {
        return this.issue.getUpdated();
    }

    public Long getWorkflowId() {
        return this.issue.getWorkflowId();
    }

    public Object getCustomFieldValue(CustomField customField) {
        return this.issue.getCustomFieldValue(customField);
    }

    public CustomField getCustomField(String id) {
        return this.customFieldManager.getCustomFieldObject(id);
    }

    public Object getCustomFieldValue(String id) {
        CustomField cf = this.customFieldManager.getCustomFieldObject(id);
        if (cf == null) {
            log.warn((Object)("Velocity template referenced nonexistent custom field '" + id + "'"));
            return null;
        }
        return this.getCustomFieldValue(cf);
    }

    public GenericValue getStatus() {
        return this.issue.getStatus();
    }

    public Status getStatusObject() {
        return this.issue.getStatusObject();
    }

    public Long getOriginalEstimate() {
        return this.issue.getOriginalEstimate();
    }

    public Long getEstimate() {
        return this.issue.getEstimate();
    }

    public Long getTimeSpent() {
        return this.issue.getTimeSpent();
    }

    public Long getAggregateOriginalEstimate() {
        return this.getAggregateBean().getOriginalEstimate();
    }

    public Long getAggregateRemainingEstimate() {
        return this.getAggregateBean().getRemainingEstimate();
    }

    public Long getAggregateTimeSpent() {
        return this.getAggregateBean().getTimeSpent();
    }

    private AggregateTimeTrackingBean getAggregateBean() {
        if (this.aggregateBean == null) {
            this.aggregateBean = this.aggregateTimeTrackingCalculatorFactory.getCalculator(this.issue).getAggregates(this.issue);
        }
        return this.aggregateBean;
    }

    public Object getExternalFieldValue(String fieldId) {
        return this.issue.getExternalFieldValue(fieldId);
    }

    public boolean isSubTask() {
        return this.issue.isSubTask();
    }

    public Long getParentId() {
        return this.issue.getParentId();
    }

    public boolean isCreated() {
        return this.issue.isCreated();
    }

    public Issue getParentObject() {
        return this.issue.getParentObject();
    }

    public GenericValue getParent() {
        return this.issue.getParent();
    }

    public Collection<GenericValue> getSubTasks() {
        return this.issue.getSubTasks();
    }

    public Collection<Issue> getSubTaskObjects() {
        return this.issue.getSubTaskObjects();
    }

    public boolean isEditable() {
        return this.issue.isEditable();
    }

    public IssueRenderContext getIssueRenderContext() {
        return this.issue.getIssueRenderContext();
    }

    public Collection<Attachment> getAttachments() {
        return this.issue.getAttachments();
    }

    public String getString(String name) {
        return this.issue.getString(name);
    }

    public Timestamp getTimestamp(String name) {
        return this.issue.getTimestamp(name);
    }

    public Set<Label> getLabels() {
        return this.issue.getLabels();
    }

    public Long getLong(String name) {
        return this.issue.getLong(name);
    }

    public GenericValue getGenericValue() {
        return this.issue.getGenericValue();
    }

    public void store() {
    }

    public String getNiceTimeOriginalEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.issue.getOriginalEstimate(), i18n);
    }

    public String getNiceTimeEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.issue.getEstimate(), i18n);
    }

    public String getNiceTimeSpent(I18nHelper i18n) {
        return this.convertToNiceTime(this.issue.getTimeSpent(), i18n);
    }

    public boolean isAnyAggregateDifferent() {
        return this.isTimeAndAggregateDifferent(this.getOriginalEstimate(), this.getAggregateOriginalEstimate()) || this.isTimeAndAggregateDifferent(this.getEstimate(), this.getAggregateRemainingEstimate()) || this.isTimeAndAggregateDifferent(this.getTimeSpent(), this.getAggregateTimeSpent());
    }

    private boolean isTimeAndAggregateDifferent(Long time, Long aggregate) {
        if (time == null) {
            return aggregate != null;
        }
        return !time.equals(aggregate);
    }

    public String getNiceTimeAggregateOriginalEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateOriginalEstimate(), i18n);
    }

    public String getNiceTimeAggregateRemainingEstimate(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateRemainingEstimate(), i18n);
    }

    public String getNiceTimeAggregateTimeSpent(I18nHelper i18n) {
        return this.convertToNiceTime(this.getAggregateTimeSpent(), i18n);
    }

    private String convertToNiceTime(Long time, I18nHelper i18n) {
        if (time == null) {
            return i18n.getText("viewissue.timetracking.unknown");
        }
        return this.jiraDurationUtils.getFormattedDuration(time, i18n.getLocale());
    }

    public String toString() {
        return "TemplateIssue[issue=" + this.issue + ']';
    }
}

