/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.mail.CssInliner;
import com.atlassian.jira.mail.Email;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.JiraMailUtils;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class RenderingMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(RenderingMailQueueItem.class);
    private final String subjectTemplatePath;
    private final String bodyTemplatePath;
    private final Map<String, Object> params;
    private final ApplicationProperties applicationProperties;
    private final MailQueue mailQueue;
    private final Email email;

    public RenderingMailQueueItem(User replyTo, NotificationRecipient recipient, String subjectTemplatePath, String bodyTemplatePath, Map<String, Object> context, ApplicationProperties applicationProperties, MailQueue mailQueue, TemplateContextFactory templateContextFactory) {
        TemplateContext templateContext;
        this.applicationProperties = applicationProperties;
        this.mailQueue = mailQueue;
        Locale locale = this.getLocale(recipient);
        String projectEmail = null;
        if (context.containsKey("issue")) {
            Issue issue = (Issue)context.get("issue");
            projectEmail = JiraMailUtils.getProjectEmailFromIssue(issue);
            IssueEvent issueEvent = new IssueEvent(issue, (Map)Maps.newHashMap(), replyTo, Long.valueOf(0L));
            templateContext = templateContextFactory.getTemplateContext(locale, issueEvent);
        } else {
            templateContext = templateContextFactory.getTemplateContext(locale);
        }
        Map<String, Object> templateParams = templateContext.getTemplateParams();
        templateParams.putAll(context);
        Email email = new Email(recipient.getEmail());
        String format = recipient.getFormat();
        email.setMimeType(RenderingMailQueueItem.getMimeTypeForFormat(format));
        email.setFrom(projectEmail);
        email.setFromName(JiraMailUtils.getFromNameForUser(replyTo));
        email.setReplyTo(replyTo.getEmailAddress());
        this.subjectTemplatePath = subjectTemplatePath;
        this.bodyTemplatePath = bodyTemplatePath;
        this.params = templateParams;
        this.email = email;
    }

    public String getSubject() {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.params);
        contextParams.put("i18n", i18n);
        try {
            return this.renderEmailSubject(contextParams);
        }
        catch (VelocityException e) {
            log.error((Object)"Could not determine e-mail subject", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void send() throws MailException {
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.params);
        try {
            String subject = this.renderEmailSubject(contextParams);
            String body = this.renderEmailBody(this.email, contextParams);
            this.email.setSubject(subject);
            this.email.setBody(body);
        }
        catch (VelocityException e) {
            throw new RuntimeException(e);
        }
        this.mailQueue.addItem((MailQueueItem)new SingleMailQueueItem((com.atlassian.mail.Email)this.email));
    }

    private String renderEmailSubject(Map<String, Object> contextParams) {
        return this.getTemplatingEngine().render(TemplateSources.file((String)this.subjectTemplatePath)).applying(contextParams).asPlainText();
    }

    private String renderEmailBody(Email message, Map<String, Object> contextParams) {
        if (message.getMimeType().equals("text/html")) {
            CssInliner cssInliner = (CssInliner)ComponentAccessor.getComponent(CssInliner.class);
            String renderedHtml = this.getTemplatingEngine().render(TemplateSources.file((String)this.bodyTemplatePath)).applying(contextParams).asHtml();
            return cssInliner.applyStyles(renderedHtml);
        }
        return this.getTemplatingEngine().render(TemplateSources.file((String)this.bodyTemplatePath)).applying(contextParams).asPlainText();
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    private Locale getLocale(NotificationRecipient recipient) {
        User toUser = recipient.getUserRecipient();
        if (toUser != null) {
            return I18nBean.getLocaleFromUser(toUser);
        }
        return this.applicationProperties.getDefaultLocale();
    }

    private static String getMimeTypeForFormat(String format) {
        if ("html".equals(format)) {
            return "text/html";
        }
        if ("text".equals(format)) {
            return "text/plain";
        }
        return format;
    }
}

