/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.RenderingMailQueueItem;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public class MentionMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(MentionMailQueueItem.class);
    private final User from;
    private final NotificationRecipient recipient;
    private final RendererManager rendererManager;
    private final Map<String, Object> context;
    private final ApplicationProperties applicationProperties;
    private final MailQueue mailQueue;
    private final TemplateContextFactory templateContextFactory;
    private final IssueRenderContext issueRenderContext;
    private final String subjectTemplatePath = "templates/email/subject/issuementioned.vm";

    public MentionMailQueueItem(User from, NotificationRecipient recipient, Map<String, Object> context, IssueRenderContext issueRenderContext, RendererManager rendererManager, ApplicationProperties applicationProperties, MailQueue mailQueue, TemplateContextFactory templateContextFactory) {
        this.from = from;
        this.recipient = recipient;
        this.rendererManager = rendererManager;
        this.context = context;
        this.applicationProperties = applicationProperties;
        this.mailQueue = mailQueue;
        this.templateContextFactory = templateContextFactory;
        this.issueRenderContext = issueRenderContext;
    }

    public String getSubject() {
        I18nHelper i18n = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
        Map<String, Object> contextParams = JiraMailQueueUtils.getContextParamsBody(this.context);
        contextParams.put("i18n", i18n);
        try {
            return this.renderEmailSubject(contextParams);
        }
        catch (VelocityException e) {
            log.error((Object)"Could not determine e-mail subject", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void send() throws MailException {
        String format = this.recipient.getFormat();
        String bodyTemplatePath = "templates/email/" + format + "/issuementioned.vm";
        String comment = (String)this.context.get("comment");
        String content = this.rendererManager.getRenderedContent("atlassian-wiki-renderer", comment, this.issueRenderContext);
        this.context.put("htmlComment", content);
        RenderingMailQueueItem item = new RenderingMailQueueItem(this.from, this.recipient, "templates/email/subject/issuementioned.vm", bodyTemplatePath, this.context, this.applicationProperties, this.mailQueue, this.templateContextFactory);
        this.mailQueue.addItem((MailQueueItem)item);
    }

    private String renderEmailSubject(Map<String, Object> contextParams) {
        return this.getTemplatingEngine().render(TemplateSources.file((String)"templates/email/subject/issuementioned.vm")).applying(contextParams).asPlainText();
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }
}

