/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;

class MovedIssueValidator {
    private final Set<Operator> supportedOperators;
    private final MovedIssueKeyStore movedIssueKeyStore;
    private final I18nHelper.BeanFactory i18nFactory;

    public MovedIssueValidator(Set<Operator> operatorsSupportingMovedIssues, MovedIssueKeyStore movedIssueKeyStore, I18nHelper.BeanFactory i18nFactory) {
        this.movedIssueKeyStore = movedIssueKeyStore;
        this.i18nFactory = i18nFactory;
        this.supportedOperators = Sets.immutableEnumSet(operatorsSupportingMovedIssues);
    }

    public MessageSet validate(ApplicationUser searcher, String key, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (this.isSupported(operator)) {
            return new MessageSetImpl();
        }
        return this.validateMovedIssue(searcher, key, operator);
    }

    private MessageSet validateMovedIssue(ApplicationUser searcher, String key, Operator operator) {
        MessageSetImpl messageSet = new MessageSetImpl();
        if (this.isMovedIssue(key)) {
            I18nHelper i18n = this.i18nFactory.getInstance(searcher);
            messageSet.addErrorMessage(i18n.getText("jira.jql.clause.issuekey.movedissue", key, operator.getDisplayString()));
        }
        return messageSet;
    }

    private boolean isSupported(Operator operator) {
        return this.supportedOperators.contains(operator);
    }

    private boolean isMovedIssue(String key) {
        return this.movedIssueKeyStore.getMovedIssueId(key.toUpperCase(Locale.ENGLISH)) != null;
    }
}

