/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.jira.jql.resolver.ComponentResolver;
import com.atlassian.jira.jql.resolver.IssueSecurityLevelResolver;
import com.atlassian.jira.jql.resolver.IssueTypeResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.PriorityResolver;
import com.atlassian.jira.jql.resolver.ProjectResolver;
import com.atlassian.jira.jql.resolver.ResolutionResolver;
import com.atlassian.jira.jql.resolver.ResolverManager;
import com.atlassian.jira.jql.resolver.StatusResolver;
import com.atlassian.jira.jql.resolver.UserResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.Transformed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class ResolverManagerImpl
implements ResolverManager {
    private static final Logger LOG = Logger.getLogger(ResolverManagerImpl.class);
    Map<String, NameResolver> map = new HashMap<String, NameResolver>();

    public ResolverManagerImpl(UserResolver userResolver, ProjectResolver projectResolver, VersionResolver versionResolver, ComponentResolver componentResolver, IssueTypeResolver issueTypeResolver, PriorityResolver priorityResolver, ResolutionResolver resolutionResolver, StatusResolver statusResolver, IssueSecurityLevelResolver issueSecurityLevelResolver, JiraAuthenticationContext jiraAuthenticationContext) {
        this.map.put("reporter", (NameResolver)userResolver);
        this.map.put("assignee", (NameResolver)userResolver);
        this.map.put("versions", (NameResolver)versionResolver);
        this.map.put("fixVersions", (NameResolver)versionResolver);
        this.map.put("project", projectResolver);
        this.map.put("components", componentResolver);
        this.map.put("issuetype", issueTypeResolver);
        this.map.put("priority", priorityResolver);
        this.map.put("resolution", resolutionResolver);
        this.map.put("status", statusResolver);
        this.map.put("security", new IssueSecurityLevelResolverFacade(issueSecurityLevelResolver, jiraAuthenticationContext));
    }

    public boolean handles(String field) {
        return this.map.containsKey(field);
    }

    public List<String> getIdsFromName(String name, String field) {
        if (!this.map.containsKey(field)) {
            throw new IllegalArgumentException("Unexpected Field class for ResolverManager of " + field);
        }
        NameResolver resolver = this.map.get(field);
        return resolver.getIdsFromName(name);
    }

    public String getSingleIdFromName(String name, String field) {
        List<String> ids = this.getIdsFromName(name, field);
        if (ids.size() == 0) {
            throw new IllegalArgumentException(String.format("There is no id for field %s with name %s", field, name));
        }
        if (ids.size() > 1) {
            LOG.debug((Object)String.format("Found more than 1 id during REST name resolution for name %s field %s.", name, field));
        }
        return ids.get(0);
    }

    public static class IssueSecurityLevelResolverFacade
    implements NameResolver {
        private final IssueSecurityLevelResolver resolver;
        private final JiraAuthenticationContext authenticationContext;

        public IssueSecurityLevelResolverFacade(IssueSecurityLevelResolver resolver, JiraAuthenticationContext authenticationContext) {
            this.resolver = resolver;
            this.authenticationContext = authenticationContext;
        }

        public List<String> getIdsFromName(String name) {
            Collection<GenericValue> levels = this.resolver.getIssueSecurityLevelsByName(this.authenticationContext.getLoggedInUser(), false, name);
            return new ArrayList<String>(Transformed.collection(levels, (Function)new Function<GenericValue, String>(){

                public String get(GenericValue gv) {
                    return gv.getString("id");
                }
            }));
        }

        public boolean nameExists(String name) {
            return this.getIdsFromName(name).size() != 0;
        }

        public boolean idExists(Long id) {
            throw new UnsupportedOperationException();
        }

        public Object get(Long id) {
            throw new UnsupportedOperationException();
        }

        public Collection getAll() {
            throw new UnsupportedOperationException();
        }
    }
}

