/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.statistics.util.LongComparator;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractDateOperatorQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class LastViewedDateClauseQueryFactory
extends AbstractDateOperatorQueryFactory
implements ClauseQueryFactory {
    private static final Logger log = Logger.getLogger(LastViewedDateClauseQueryFactory.class);
    private final JqlOperandResolver operandResolver;
    private final UserIssueHistoryManager historyManager;

    public LastViewedDateClauseQueryFactory(JqlDateSupport jqlDateSupport, JqlOperandResolver operandResolver, UserIssueHistoryManager historyManager) {
        super(jqlDateSupport);
        this.operandResolver = operandResolver;
        this.historyManager = historyManager;
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (this.operandResolver.isValidOperand(operand)) {
            if (this.handlesOperator(operator)) {
                List fullHistory = this.historyManager.getFullIssueHistoryWithoutPermissionChecks(queryCreationContext.getUser());
                if (!fullHistory.isEmpty()) {
                    if (this.operandResolver.isEmptyOperand(operand)) {
                        return this.createQueryForEmptyOperand(operator, fullHistory);
                    }
                    List<QueryLiteral> rawValues = this.getRawValues(queryCreationContext, terminalClause);
                    List<Date> dateValues = this.getDateValues(rawValues);
                    if (this.operandResolver.isListOperand(operand)) {
                        return this.createQueryForMultipleValues(operator, dateValues, fullHistory);
                    }
                    return this.createQueryForSingleValue(operator, dateValues, fullHistory);
                }
                return QueryFactoryResult.createFalseResult();
            }
            log.debug((Object)String.format("The '%s' clause does not support the %s operator.", terminalClause.getName(), operator.getDisplayString()));
            return QueryFactoryResult.createFalseResult();
        }
        log.debug((Object)String.format("There is no OperandHandler registered to handle the operand '%s' for operand '%s'.", operator.getDisplayString(), terminalClause.getOperand().getDisplayString()));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult createQueryForSingleValue(Operator operator, List<Date> dates, List<UserHistoryItem> history) {
        if (operator == Operator.EQUALS) {
            return this.handleIn(dates, history, false);
        }
        if (operator == Operator.NOT_EQUALS) {
            return this.handleIn(dates, history, true);
        }
        if (dates.isEmpty()) {
            return QueryFactoryResult.createFalseResult();
        }
        Date date = dates.get(0);
        if (date == null) {
            return QueryFactoryResult.createFalseResult();
        }
        if (operator == Operator.LESS_THAN) {
            return new QueryFactoryResult(this.generateQueryForHistory(this.getHistoryItemsLessThan(date, history)));
        }
        if (operator == Operator.LESS_THAN_EQUALS) {
            return new QueryFactoryResult(this.generateQueryForHistory(this.getHistoryItemsLessThanOrEqual(date, history)));
        }
        if (operator == Operator.GREATER_THAN_EQUALS) {
            return new QueryFactoryResult(this.generateQueryForHistory(this.getHistoryItemsGreaterThanOrEqual(date, history)));
        }
        if (operator == Operator.GREATER_THAN) {
            return new QueryFactoryResult(this.generateQueryForHistory(this.getHistoryItemsGreaterThan(date, history)));
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult createQueryForMultipleValues(Operator operator, List<Date> dates, List<UserHistoryItem> history) {
        if (operator == Operator.IN) {
            return this.handleIn(dates, history, false);
        }
        if (operator == Operator.NOT_IN) {
            return this.handleIn(dates, history, true);
        }
        log.debug((Object)String.format("Creating an equality query for multiple values for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", "lastViewed", operator, Operator.IN, Operator.NOT_IN));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult createQueryForEmptyOperand(Operator operator, List<UserHistoryItem> historyItems) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.generateQueryForHistory(historyItems), true);
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.generateQueryForHistory(historyItems));
        }
        log.debug((Object)String.format("Creating an equality query for an empty value for date field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", "lastViewed", operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS));
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleIn(List<Date> dates, List<UserHistoryItem> history, boolean negate) {
        if (dates.size() == 1) {
            Date date = dates.get(0);
            return date == null ? new QueryFactoryResult(this.generateQueryForHistory(history), !negate) : new QueryFactoryResult(this.generateQueryForHistory(this.getEqualHistoryItems(date, history)), negate);
        }
        boolean foundEmpty = false;
        TreeSet<UserHistoryItem> matchingHistoryItems = new TreeSet<UserHistoryItem>(new Comparator<UserHistoryItem>(){

            @Override
            public int compare(UserHistoryItem o1, UserHistoryItem o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return LongComparator.COMPARATOR.compare(o1.getLastViewed(), o2.getLastViewed());
            }
        });
        for (Date date : dates) {
            if (date == null) {
                foundEmpty = true;
                continue;
            }
            matchingHistoryItems.addAll(this.getEqualHistoryItems(date, history));
        }
        if (!foundEmpty) {
            return new QueryFactoryResult(this.generateQueryForHistory(matchingHistoryItems), negate);
        }
        ArrayList userHistoryItems = Lists.newArrayList(history);
        userHistoryItems.removeAll(matchingHistoryItems);
        BooleanQuery combined = new BooleanQuery();
        for (UserHistoryItem item : userHistoryItems) {
            combined.add((Query)new TermQuery(new Term(SystemSearchConstants.forIssueId().getIndexField(), item.getEntityId())), BooleanClause.Occur.MUST_NOT);
        }
        return new QueryFactoryResult((Query)combined, negate);
    }

    private Query generateQueryForHistory(Collection<UserHistoryItem> history) {
        BooleanQuery combined = new BooleanQuery();
        for (UserHistoryItem item : history) {
            combined.add((Query)new TermQuery(new Term(SystemSearchConstants.forIssueId().getIndexField(), item.getEntityId())), BooleanClause.Occur.SHOULD);
        }
        return combined;
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains(operator) || OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    List<QueryLiteral> getRawValues(QueryCreationContext queryCreationContext, TerminalClause clause) {
        return this.operandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
    }

    private List<UserHistoryItem> getEqualHistoryItems(Date date, List<UserHistoryItem> history) {
        final long time = date.getTime();
        Predicate<UserHistoryItem> predicate = new Predicate<UserHistoryItem>(){

            public boolean apply(@Nullable UserHistoryItem input) {
                return input.getLastViewed() == time;
            }
        };
        return this.generateNewList(history, predicate);
    }

    private List<UserHistoryItem> getHistoryItemsLessThan(Date date, List<UserHistoryItem> history) {
        final long time = date.getTime();
        Predicate<UserHistoryItem> predicate = new Predicate<UserHistoryItem>(){

            public boolean apply(@Nullable UserHistoryItem input) {
                return input.getLastViewed() < time;
            }
        };
        return this.generateNewList(history, predicate);
    }

    private List<UserHistoryItem> getHistoryItemsLessThanOrEqual(Date date, List<UserHistoryItem> history) {
        final long time = date.getTime();
        Predicate<UserHistoryItem> predicate = new Predicate<UserHistoryItem>(){

            public boolean apply(@Nullable UserHistoryItem input) {
                return input.getLastViewed() <= time;
            }
        };
        return this.generateNewList(history, predicate);
    }

    private List<UserHistoryItem> getHistoryItemsGreaterThanOrEqual(Date date, List<UserHistoryItem> history) {
        final long time = date.getTime();
        Predicate<UserHistoryItem> predicate = new Predicate<UserHistoryItem>(){

            public boolean apply(@Nullable UserHistoryItem input) {
                return input.getLastViewed() >= time;
            }
        };
        return this.generateNewList(history, predicate);
    }

    private List<UserHistoryItem> getHistoryItemsGreaterThan(Date date, List<UserHistoryItem> history) {
        final long time = date.getTime();
        Predicate<UserHistoryItem> predicate = new Predicate<UserHistoryItem>(){

            public boolean apply(@Nullable UserHistoryItem input) {
                return input.getLastViewed() > time;
            }
        };
        return this.generateNewList(history, predicate);
    }

    private List<UserHistoryItem> generateNewList(List<UserHistoryItem> history, Predicate<UserHistoryItem> predicate) {
        return Lists.newArrayList((Iterable)Iterables.filter(history, predicate));
    }
}

