/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.jql.query.AbstractEqualityQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.query.operator.Operator;
import org.apache.log4j.Logger;
import org.apache.lucene.search.Query;

public class EqualityWithSpecifiedEmptyValueQueryFactory<T>
extends AbstractEqualityQueryFactory<T> {
    private static final Logger log = Logger.getLogger(EqualityWithSpecifiedEmptyValueQueryFactory.class);
    private final String emptyValue;

    public EqualityWithSpecifiedEmptyValueQueryFactory(IndexInfoResolver<T> indexInfoResolver, String emptyValue) {
        super(indexInfoResolver);
        this.emptyValue = emptyValue;
    }

    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(fieldName));
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery(fieldName));
        }
        log.debug((Object)String.format("Cannot create a query for an empty operand using the operator '%s'", operator.getDisplayString()));
        return QueryFactoryResult.createFalseResult();
    }

    Query getIsEmptyQuery(String fieldName) {
        return this.getTermQuery(fieldName, this.emptyValue);
    }

    Query getIsNotEmptyQuery(String fieldName) {
        QueryFactoryResult result = new QueryFactoryResult((Query)this.getTermQuery(fieldName, this.emptyValue), true);
        return QueryFactoryResult.wrapWithVisibilityQuery((String)fieldName, (QueryFactoryResult)result).getLuceneQuery();
    }
}

