/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly.tag.project;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.ProjectContextAccessor;
import com.atlassian.jira.jelly.ProjectContextAccessorImpl;
import com.atlassian.jira.jelly.tag.JellyUtils;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.base.Strings;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.MissingAttributeException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.XMLOutput;
import org.ofbiz.core.entity.GenericValue;

public class CreateProject
extends JiraDynaBeanTagSupport
implements ProjectContextAccessor {
    private final ProjectService projectService = (ProjectService)ComponentAccessor.getComponentOfType(ProjectService.class);
    private final JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
    private String projectKey;
    private String projectName;
    private String projectLeadUsername;
    private static final String KEY_PROJECTKEY = "key";
    private static final String KEY_PROJECTNAME = "name";
    private static final String KEY_PROJECTLEAD = "lead";
    private final ProjectContextAccessor projectContextAccessor = new ProjectContextAccessorImpl((Tag)this);

    public void doTag(XMLOutput output) throws JellyTagException {
        ProjectService.CreateProjectValidationResult validationResult;
        this.validateParams();
        Long defaultAssignee = 2L;
        if (ComponentAccessor.getApplicationProperties().getOption("jira.option.allowunassigned")) {
            defaultAssignee = 3L;
        }
        if ((validationResult = this.projectService.validateCreateProject(this.getLoggedInUser(), this.getProjectName(), this.getProjectKey(), "", this.getLeadUserName(), "", defaultAssignee)).isValid()) {
            Project project = this.projectService.createProject(validationResult);
            this.setProject(project.getKey());
            Script body = this.getBody();
            if (body != null) {
                body.run(this.context, output);
            }
        } else {
            JellyUtils.processErrorCollection(validationResult.getErrorCollection());
        }
    }

    private void validateParams() throws MissingAttributeException {
        if (Strings.isNullOrEmpty((String)this.getProjectKey())) {
            throw new MissingAttributeException(KEY_PROJECTKEY);
        }
        if (Strings.isNullOrEmpty((String)this.getProjectName())) {
            throw new MissingAttributeException(KEY_PROJECTNAME);
        }
        if (Strings.isNullOrEmpty((String)this.getLeadUserName())) {
            throw new MissingAttributeException(KEY_PROJECTLEAD);
        }
    }

    @Override
    public void setProject(Long projectId) {
        this.projectContextAccessor.setProject(projectId);
    }

    @Override
    public void setProject(String projectKey) {
        this.projectContextAccessor.setProject(projectKey);
    }

    @Override
    public void setProject(GenericValue project) {
        this.projectContextAccessor.setProject(project);
    }

    @Override
    public void loadPreviousProject() {
        this.projectContextAccessor.loadPreviousProject();
    }

    private String getProjectKey() {
        if (Strings.isNullOrEmpty((String)this.projectKey)) {
            this.projectKey = (String)this.getProperties().get(KEY_PROJECTKEY);
        }
        return this.projectKey;
    }

    private String getProjectName() {
        if (Strings.isNullOrEmpty((String)this.projectName)) {
            this.projectName = (String)this.getProperties().get(KEY_PROJECTNAME);
        }
        return this.projectName;
    }

    private String getLeadUserName() {
        if (Strings.isNullOrEmpty((String)this.projectLeadUsername)) {
            this.projectLeadUsername = (String)this.getProperties().get(KEY_PROJECTLEAD);
        }
        return this.projectLeadUsername;
    }

    public User getLoggedInUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

