/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jelly;

import com.atlassian.jira.jelly.JellyHttpRequest;
import com.atlassian.jira.jelly.JellyHttpResponse;
import com.atlassian.jira.jelly.JiraDynaBeanTagSupport;
import com.atlassian.jira.jelly.WebWorkAdaptor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpUtils;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.XMLOutput;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public abstract class ActionTagSupport
extends JiraDynaBeanTagSupport {
    private static final Logger log = Logger.getLogger(ActionTagSupport.class);
    protected static final boolean SUCCESS = true;
    protected static final boolean FAILURE = false;
    private boolean executeWebworkOnClose = false;
    private String actionName = "invalid_action_name";
    protected boolean ignoreErrors;
    private WebWorkAdaptor webWorkAdaptor = null;

    public boolean isExecuteWebworkOnClose() {
        return this.executeWebworkOnClose;
    }

    public void setExecuteWebworkOnClose(boolean executeWebworkOnClose) {
        this.executeWebworkOnClose = executeWebworkOnClose;
    }

    public String getActionName() {
        return this.actionName;
    }

    protected void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public void setProperty(String key, String value) {
        this.getProperties().put(key, value);
    }

    public void setProperty(String key, String[] value) {
        this.getProperties().put(key, value);
    }

    public String getProperty(String key) {
        return (String)this.getProperties().get(key);
    }

    protected boolean propertyContains(String key) {
        return this.getProperties().containsKey(key);
    }

    public JellyHttpResponse getResponse() {
        return this.getWebWorkAdaptor().getJellyHttpResponse();
    }

    public void beforeSetAttributes() throws JellyTagException {
        super.beforeSetAttributes();
        super.getProperties().clear();
    }

    public JellyHttpRequest getRequest() {
        return this.getWebWorkAdaptor().getJellyHttpRequest();
    }

    public WebWorkAdaptor getWebWorkAdaptor() {
        if (this.webWorkAdaptor == null) {
            this.webWorkAdaptor = new WebWorkAdaptor();
        }
        return this.webWorkAdaptor;
    }

    public String toString() {
        return "(" + this.getTagName() + this.getDynaBean().toString() + ")";
    }

    public void doTag(XMLOutput output) throws JellyTagException {
        log.debug((Object)("ActionTagSupport.doTag :" + this.toString()));
        this.preContextValidation();
        if (this.contextValidation(output)) {
            this.prePropertyValidation(output);
            boolean preTagValid = this.propertyValidation(output);
            this.runTagAndPostTag(preTagValid, output);
        }
        this.endTagExecution(output);
    }

    private void runTagAndPostTag(boolean preTagValid, XMLOutput output) throws JellyTagException {
        if (preTagValid) {
            if (this.isExecuteWebworkOnClose()) {
                this.invokeNestedTag(output);
            }
            if (this.getWebWorkAdaptor().mapJellyTagToAction(this, output)) {
                this.postTagExecution(output);
                this.postTagValidation(output);
                if (!this.isExecuteWebworkOnClose()) {
                    this.invokeNestedTag(output);
                }
            } else if (this.ignoreErrors) {
                this.invokeNestedTag(output);
            }
        }
    }

    private void invokeNestedTag(XMLOutput output) throws JellyTagException {
        Script body = this.getBody();
        if (body != null) {
            body.run(this.context, output);
        }
    }

    protected void preContextValidation() {
        log.debug((Object)"ActionTagSupport.preContextValidation");
    }

    protected boolean contextValidation(XMLOutput output) throws JellyTagException {
        log.debug((Object)"CreateProject.contextValidation");
        return this.contextContainsBefore(this.getRequiredContextVariables(), output);
    }

    protected void prePropertyValidation(XMLOutput output) throws JellyTagException {
        log.debug((Object)"ActionTagSupport.prePropertyValidation");
    }

    protected boolean propertyValidation(XMLOutput output) throws JellyTagException {
        return this.propertiesContains(this.getRequiredProperties(), output);
    }

    protected void postTagExecution(XMLOutput output) throws JellyTagException {
        log.debug((Object)"ActionTagSupport.postTagExecution");
    }

    protected void postTagValidation(XMLOutput output) throws JellyTagException {
        this.contextContainsAfter(this.getRequiredContextVariablesAfter(), output);
    }

    protected void endTagExecution(XMLOutput output) {
        log.debug((Object)"ActionTagSupport.endTagExecution");
    }

    protected void copyRedirectUrlParametersToTag(String url) {
        String queryString;
        Hashtable parameters;
        String value;
        int endIndex;
        log.debug((Object)"ActionTagSupport.copyRedirectUrlParametersToTag");
        int question = url.indexOf("?");
        String searchUrl = "/browse/";
        int browseIndex = url.indexOf(searchUrl);
        if (browseIndex != -1) {
            endIndex = question >= 0 ? question : url.length();
            value = url.substring(browseIndex + searchUrl.length(), endIndex);
            this.setProperty("key", value);
        }
        if ((browseIndex = url.indexOf(searchUrl = "plugins/servlet/project-config/")) != -1) {
            browseIndex += searchUrl.length();
            endIndex = url.lastIndexOf("/");
            if (endIndex != -1) {
                value = url.substring(browseIndex, endIndex);
                this.setProperty("key", value);
            } else {
                value = url.substring(browseIndex);
                this.setProperty("key", value);
            }
        }
        if (question >= 0 && !(parameters = HttpUtils.parseQueryString((String)(queryString = url.substring(question + 1, url.length())))).isEmpty()) {
            for (String key : parameters.keySet()) {
                String value2 = ((String[])parameters.get(key))[0];
                if (this.getProperties().containsKey(key)) {
                    log.warn((Object)("ActionTagSupport.copyRedirectUrlParametersToTag : Overwriting property " + key));
                }
                this.setProperty(key, value2);
            }
        }
    }

    protected String getTagName() {
        return this.getTagName((Tag)this);
    }

    protected String getTagName(Tag tag) {
        String fullClassName = tag.getClass().getName();
        int startPos = fullClassName.lastIndexOf(46) + 1;
        String tagName = fullClassName.substring(startPos, fullClassName.length());
        return tagName;
    }

    protected boolean contextContainsBefore(String[] requiredContextVariablesBefore, XMLOutput output) throws JellyTagException {
        Map variables = this.getContext().getVariables();
        boolean containsAll = this.mapContainsAll(requiredContextVariablesBefore, variables);
        if (!containsAll) {
            this.reportRequiredContextVariablesBefore(requiredContextVariablesBefore, variables, output);
        }
        return containsAll;
    }

    protected boolean contextContainsAfter(String[] requiredContextVariablesAfter, XMLOutput output) throws JellyTagException {
        Map variables = this.getContext().getVariables();
        boolean containsAll = this.mapContainsAll(requiredContextVariablesAfter, variables);
        if (!containsAll) {
            this.reportRequiredContextVariablesAfter(requiredContextVariablesAfter, output);
        }
        return containsAll;
    }

    protected boolean propertiesContains(String[] requiredProperties, XMLOutput output) throws JellyTagException {
        Map properties = this.getProperties();
        boolean containsAll = this.mapContainsAll(requiredProperties, properties);
        if (!containsAll) {
            this.reportRequiredProperties(requiredProperties, output);
        }
        return containsAll;
    }

    protected boolean mapContainsAll(String[] requiredContextVariables, Map map) {
        boolean valid = true;
        for (String requiredContextVariable : requiredContextVariables) {
            if (!map.containsKey(requiredContextVariable)) {
                valid = false;
                continue;
            }
            if (map.get(requiredContextVariable) != null) continue;
            map.remove(requiredContextVariable);
            valid = false;
        }
        return valid;
    }

    protected void reportRequiredContextVariablesBefore(String[] requiredContextVariables, Map current, XMLOutput output) throws JellyTagException {
        String MESSAGE_SUFFIX = "variables to be set in the Context";
        this.reportRequired(requiredContextVariables, "variables to be set in the Context", output, null);
    }

    protected void reportRequiredProperties(String[] requiredProperties, XMLOutput output) throws JellyTagException {
        String MESSAGE_SUFFIX = "properties to be set";
        this.reportRequired(requiredProperties, "properties to be set", output, null);
    }

    protected void reportRequiredContextVariablesAfter(String[] requiredContextVariablesAfter, XMLOutput output) throws JellyTagException {
        String MESSAGE_SUFFIX = "variables to be set in the Context after execution of the tag";
        this.reportRequired(requiredContextVariablesAfter, "variables to be set in the Context after execution of the tag", output, null);
    }

    protected void reportRequired(String[] required, String MESSAGE_SUFFIX, XMLOutput output, Map current) throws JellyTagException {
        try {
            String tagName = this.getTagName();
            StringBuffer errorMsg = new StringBuffer("Tag " + tagName + " requires (" + this.arrayToString(required) + ") " + MESSAGE_SUFFIX);
            if (current != null) {
                errorMsg.append(current.toString());
            }
            WebWorkAdaptor.writeErrorToXmlOutput(output, errorMsg, this.getActionName(), (TagSupport)this);
        }
        catch (SAXException e) {
            log.error((Object)e, (Throwable)e);
            throw new JellyTagException((Throwable)e);
        }
    }

    protected String arrayToString(String[] array) {
        String SEPERATOR = ", ";
        StringBuilder stringBuffer = new StringBuilder();
        if (array.length != 0) {
            for (String anArray : array) {
                stringBuffer.append(anArray);
                stringBuffer.append(", ");
            }
            stringBuffer.delete(stringBuffer.length() - ", ".length(), stringBuffer.length());
        }
        return stringBuffer.toString();
    }

    public abstract String[] getRequiredProperties();

    public abstract String[] getRequiredContextVariablesAfter();

    public abstract String[] getRequiredContextVariables();

    protected void mapProperty(String mapFromKey, Map mapping, String propertyName, XMLOutput output) throws SAXException {
        this.mapProperty(mapFromKey, mapFromKey, mapping, propertyName, output);
    }

    protected void mapProperty(String mapFromKey, String mapToKey, Map mapping, String propertyName, XMLOutput output) throws SAXException {
        String mapFrom = this.getProperty(mapFromKey);
        if (mapFrom != null) {
            mapFrom = mapFrom.trim();
            try {
                Long id = new Long(Long.parseLong(mapFrom));
                if (!mapping.containsKey(id)) {
                    this.createError(propertyName, mapFrom, mapping, output);
                }
            }
            catch (NumberFormatException ignore) {
                Object keyFromValue = this.getKeyFromValue(mapping, mapFrom);
                if (keyFromValue == null) {
                    this.createError(propertyName, mapFrom, mapping, output);
                }
                this.setProperty(mapToKey, keyFromValue.toString());
            }
        }
    }

    private Object getKeyFromValue(Map map, String value) {
        Set set = map.entrySet();
        for (Map.Entry aSet : set) {
            Map.Entry entry = aSet;
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void createError(String propertyName, String mapFrom, Map mapping, XMLOutput output) throws SAXException {
        StringBuffer errorMsg = new StringBuffer("Unknown " + propertyName + " \"" + mapFrom + "\". ");
        errorMsg.append("Known values are : ");
        Iterator iterator = mapping.keySet().iterator();
        while (iterator.hasNext()) {
            errorMsg.append("[").append(iterator.next()).append("]");
        }
        WebWorkAdaptor.writeErrorToXmlOutput(output, errorMsg, this.getActionName(), (TagSupport)this);
    }
}

