/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.status.category;

import com.atlassian.jira.issue.status.category.StatusCategory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class StatusCategoryImpl
implements StatusCategory {
    private static final List<StatusCategory> CATEGORIES = ImmutableList.of((Object)new StatusCategoryImpl(1L, "undefined", "medium-gray", 1L), (Object)new StatusCategoryImpl(2L, "new", "blue", 2L), (Object)new StatusCategoryImpl(3L, "done", "green", 3L), (Object)new StatusCategoryImpl(4L, "indeterminate", "yellow", 4L));
    private static final Map<String, StatusCategory> CATEGORIES_BY_KEY;
    private static final Map<Long, StatusCategory> CATEGORIES_BY_ID;
    private final Long id;
    private final String key;
    private final String colorName;
    private final Long sequence;

    private StatusCategoryImpl(Long id, String key, String colorName, Long sequence) {
        this.id = id;
        this.key = key;
        this.colorName = colorName;
        this.sequence = sequence;
    }

    public Long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getColorName() {
        return this.colorName;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public int compareTo(StatusCategory o) {
        return this.id.compareTo(o.getId());
    }

    public static StatusCategory findById(Long id) {
        return CATEGORIES_BY_ID.get(id);
    }

    public static StatusCategory getDefault() {
        return CATEGORIES_BY_KEY.get("undefined");
    }

    static {
        CATEGORIES_BY_ID = Maps.uniqueIndex(CATEGORIES, (Function)new Function<StatusCategory, Long>(){

            public Long apply(@Nullable StatusCategory input) {
                return input.getId();
            }
        });
        CATEGORIES_BY_KEY = Maps.uniqueIndex(CATEGORIES, (Function)new Function<StatusCategory, String>(){

            public String apply(@Nullable StatusCategory input) {
                return input.getKey();
            }
        });
    }
}

