/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueKey;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.IssueUtils;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comparator.IssueKeyComparator;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.managers.IssueDeleteHelper;
import com.atlassian.jira.issue.search.parameters.filter.NoBrowsePermissionPredicate;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.issue.util.MovedIssueKeyStore;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.InvalidInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueManager
implements IssueManager {
    private final OfBizDelegator ofBizDelegator;
    private final WorkflowManager workflowManager;
    private final NodeAssociationStore nodeAssociationStore;
    private final UserAssociationStore userAssociationStore;
    private final IssueUpdater issueUpdater;
    private IssueDeleteHelper issueDeleteHelper;
    private FieldManager fieldManager;
    private FieldLayoutManager fieldLayoutManager;
    private final PermissionManager permissionManager;
    private final MovedIssueKeyStore movedIssueKeyStore;
    private final Map<String, Object> unassignedCondition = Collections.singletonMap("assignee", null);
    private final IssueFinder issueFinder = new IssueFinder(){

        @Override
        protected Project getProjectByKey(String projectKey) {
            return DefaultIssueManager.this.getProjectManager().getProjectObjByKey(projectKey);
        }
    };
    private final IssueFinder caseInsensitiveIssueFinder = new IssueFinder(){

        @Override
        protected Project getProjectByKey(String projectKey) {
            return DefaultIssueManager.this.getProjectManager().getProjectObjByKeyIgnoreCase(projectKey);
        }
    };

    public DefaultIssueManager(OfBizDelegator ofBizDelegator, WorkflowManager workflowManager, NodeAssociationStore nodeAssociationStore, UserAssociationStore userAssociationStore, IssueUpdater issueUpdater, PermissionManager permissionManager, MovedIssueKeyStore movedIssueKeyStore) {
        this.ofBizDelegator = ofBizDelegator;
        this.workflowManager = workflowManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.userAssociationStore = userAssociationStore;
        this.issueUpdater = issueUpdater;
        this.permissionManager = permissionManager;
        this.movedIssueKeyStore = movedIssueKeyStore;
    }

    public GenericValue getIssue(Long id) throws DataAccessException {
        if (id == null) {
            return null;
        }
        return this.ofBizDelegator.findById("Issue", id);
    }

    public GenericValue getIssue(String key) throws GenericEntityException {
        return this.getIssueFinder().getIssue(key);
    }

    public boolean isExistingIssueKey(String issueKey) throws GenericEntityException {
        return this.getIssue(issueKey) != null;
    }

    public List<GenericValue> getIssues(Collection<Long> ids) {
        ArrayList<EntityExpr> entityExpressions = new ArrayList<EntityExpr>();
        List unsortedIssues = null;
        int batchSize = DefaultOfBizDelegator.getQueryBatchSize();
        int i = 0;
        for (Long issueId : ids) {
            entityExpressions.add(new EntityExpr("id", EntityOperator.EQUALS, (Object)issueId));
            if (++i < batchSize) continue;
            if (unsortedIssues == null) {
                unsortedIssues = this.ofBizDelegator.findByOr("Issue", entityExpressions, null);
            } else {
                unsortedIssues.addAll(this.ofBizDelegator.findByOr("Issue", entityExpressions, null));
            }
            entityExpressions = new ArrayList();
            i = 0;
        }
        if (!entityExpressions.isEmpty()) {
            if (unsortedIssues == null) {
                unsortedIssues = this.ofBizDelegator.findByOr("Issue", entityExpressions, null);
            } else {
                unsortedIssues.addAll(this.ofBizDelegator.findByOr("Issue", entityExpressions, null));
            }
        }
        return this.getIssuesSortedByIds(unsortedIssues, ids);
    }

    public List<Issue> getIssueObjects(Collection<Long> ids) {
        return Lists.transform(this.getIssues(ids), (Function)new Function<GenericValue, Issue>(){

            public Issue apply(@Nullable GenericValue from) {
                return DefaultIssueManager.this.getIssueFactory().getIssue(from);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getIssueIdsForProject(Long projectId) throws GenericEntityException {
        if (projectId == null) {
            throw new NullPointerException("Project Id cannot be null.");
        }
        EntityListIterator issueIterator = null;
        ArrayList<Long> issueIds = new ArrayList<Long>();
        try {
            issueIterator = ((DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class)).findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND), (Collection)ImmutableList.of((Object)"id"), null);
            GenericValue issueIdGV = issueIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = issueIterator.next();
            }
        }
        finally {
            if (issueIterator != null) {
                issueIterator.close();
            }
        }
        return issueIds;
    }

    public long getIssueCountForProject(Long projectId) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"project", (Object)projectId), EntityOperator.AND);
        GenericValue countGV = EntityUtil.getOnly((List)this.ofBizDelegator.findByCondition("IssueCount", (EntityCondition)condition, Collections.singletonList("count"), Collections.emptyList()));
        long count = countGV.getLong("count");
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUnassignedIssues() {
        OfBizListIterator unassignedIssuesIt = this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityFieldMap(this.unassignedCondition, EntityOperator.EQUALS), null, (Collection)ImmutableList.of((Object)"id"), (List)ImmutableList.of((Object)"id"), EntityFindOptions.findOptions().maxResults(1));
        try {
            boolean bl = unassignedIssuesIt.next() != null;
            return bl;
        }
        finally {
            unassignedIssuesIt.close();
        }
    }

    public long getUnassignedIssueCount() {
        List unassignedCount = this.ofBizDelegator.findByCondition("IssueCountByAssignee", (EntityCondition)new EntityFieldMap(this.unassignedCondition, EntityOperator.EQUALS), (Collection)ImmutableList.of((Object)"count"), null);
        return EntityUtil.getOnly((List)unassignedCount).getLong("count");
    }

    public Issue findMovedIssue(String originalKey) {
        Assertions.notNull((String)"originalKey", (Object)originalKey);
        String key = originalKey.toUpperCase();
        Long issueId = this.movedIssueKeyStore.getMovedIssueId(key);
        if (issueId != null) {
            return this.getIssueObject(issueId);
        }
        return null;
    }

    public void recordMovedIssueKey(Issue oldIssue) {
        Set projectKeys = this.getProjectManager().getAllProjectKeys(oldIssue.getProjectId());
        for (String projectKey : projectKeys) {
            String oldIssueKey = IssueKey.format((String)projectKey, (long)oldIssue.getNumber());
            this.movedIssueKeyStore.recordMovedIssueKey(oldIssueKey, oldIssue.getId());
        }
    }

    private List<GenericValue> getIssuesSortedByIds(Collection<GenericValue> unsortedIssues, Collection<Long> ids) {
        HashMap<Long, GenericValue> idToIssue = new HashMap<Long, GenericValue>();
        for (GenericValue issue : unsortedIssues) {
            idToIssue.put(issue.getLong("id"), issue);
        }
        ArrayList<GenericValue> sortedIssues = new ArrayList<GenericValue>();
        for (Long id : ids) {
            sortedIssues.add((GenericValue)idToIssue.get(id));
        }
        return sortedIssues;
    }

    public GenericValue getIssueByWorkflow(Long wfid) throws GenericEntityException {
        return EntityUtil.getOnly((List)this.ofBizDelegator.findByAnd("Issue", EasyMap.build((Object)"workflowId", (Object)wfid)));
    }

    public MutableIssue getIssueObjectByWorkflow(Long workflowId) throws GenericEntityException {
        return this.getIssueObject(this.getIssueByWorkflow(workflowId));
    }

    public MutableIssue getIssueObject(Long id) throws DataAccessException {
        GenericValue issueGV = this.getIssue(id);
        if (issueGV == null) {
            return null;
        }
        return this.getIssueObject(issueGV);
    }

    public MutableIssue getIssueObject(String key) throws DataAccessException {
        try {
            GenericValue issueGV = this.getIssue(key);
            if (issueGV == null) {
                return null;
            }
            return this.getIssueObject(issueGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public MutableIssue getIssueByKeyIgnoreCase(String key) throws DataAccessException {
        try {
            GenericValue issueGV = this.getCaseInsensitiveIssueFinder().getIssue(key);
            if (issueGV == null) {
                return null;
            }
            return this.getIssueObject(issueGV);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public MutableIssue getIssueByCurrentKey(String key) throws DataAccessException {
        GenericValue issue;
        try {
            issue = this.getIssueFinder().getIssue(key);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        if (issue != null && issue.getString("key").equals(key)) {
            return this.getIssueObject(issue);
        }
        return null;
    }

    public List<GenericValue> getEntitiesByIssue(String relationName, GenericValue issue) throws GenericEntityException {
        if (relationName.equals("IssueComponent")) {
            return this.nodeAssociationStore.getSinksFromSource(issue, "Component", relationName);
        }
        if (relationName.equals("IssueFixVersion")) {
            return this.nodeAssociationStore.getSinksFromSource(issue, "Version", relationName);
        }
        if (relationName.equals("IssueVersion")) {
            return this.nodeAssociationStore.getSinksFromSource(issue, "Version", relationName);
        }
        if (relationName.equals("IssueChangeGroups")) {
            return issue.getRelatedCache("ChildChangeGroup");
        }
        if (relationName.equals("IssueWorkflowHistory")) {
            return this.workflowManager.makeWorkflowWithUserKey(null).getHistorySteps(issue.getLong("workflowId").longValue());
        }
        if (relationName.equals("IssueComments")) {
            return issue.getRelatedByAnd("ChildAction", MapBuilder.build((Object)"type", (Object)"comment"));
        }
        if (relationName.equals("IssueWorklog")) {
            return issue.getRelated("ChildWorklog");
        }
        if (relationName.equals("IssueLinksInward")) {
            return this.ofBizDelegator.findByAnd("IssueLink", MapBuilder.build((Object)"destination", (Object)issue.getLong("id")));
        }
        if (relationName.equals("IssueLinksOutward")) {
            return this.ofBizDelegator.findByAnd("IssueLink", MapBuilder.build((Object)"source", (Object)issue.getLong("id")));
        }
        if (relationName.equals("IssueCustomFieldValues")) {
            return this.ofBizDelegator.findByAnd("CustomFieldValue", MapBuilder.build((Object)"issue", (Object)issue.getLong("id")));
        }
        return Collections.emptyList();
    }

    public List<GenericValue> getEntitiesByIssueObject(String relationName, Issue issue) throws GenericEntityException {
        return this.getEntitiesByIssue(relationName, issue.getGenericValue());
    }

    public List<GenericValue> getIssuesByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return this.nodeAssociationStore.getSourcesFromSink(entity, "Issue", relationName);
    }

    public List<Issue> getIssueObjectsByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return Lists.transform(this.getIssuesByEntity(relationName, entity), (Function)new Function<GenericValue, Issue>(){

            public Issue apply(@Nullable GenericValue from) {
                return DefaultIssueManager.this.getIssueFactory().getIssue(from);
            }
        });
    }

    public Set<String> getAllIssueKeys(Long issueId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        MutableIssue issue = this.getIssueObject(issueId);
        Project project = issue.getProjectObject();
        Set projectKeys = this.getProjectManager().getAllProjectKeys(project.getId());
        return ImmutableSet.builder().addAll(this.getPreviousIssueKeysForMovedIssues(issueId)).addAll((Iterable)Collections2.transform((Collection)projectKeys, (Function)new Function<String, String>((Issue)issue){
            final /* synthetic */ Issue val$issue;
            {
                this.val$issue = issue;
            }

            public String apply(String projectKey) {
                return IssueKey.format((String)projectKey, (long)this.val$issue.getNumber());
            }
        })).build();
    }

    private Collection<String> getPreviousIssueKeysForMovedIssues(Long issueId) {
        try {
            EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"issueId", (Object)issueId), EntityOperator.AND);
            List gvs = this.ofBizDelegator.findByCondition("MovedIssueKey", (EntityCondition)condition, (Collection)ImmutableList.of((Object)"oldIssueKey"), (List)ImmutableList.of((Object)"id"));
            return this.collectPreviousIssueKeys(gvs);
        }
        catch (DataAccessException e) {
            return Collections.emptySet();
        }
    }

    private Collection<String> collectPreviousIssueKeys(List<GenericValue> issueChangeItemIteratorGVs) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (GenericValue issueChangeItemIteratorGV : issueChangeItemIteratorGVs) {
            result.add(issueChangeItemIteratorGV.getString("oldIssueKey"));
        }
        return result;
    }

    public GenericValue createIssue(User remoteUser, Map<String, Object> fields) throws CreateException {
        return this.createIssue(remoteUser != null ? remoteUser.getName() : null, fields);
    }

    public GenericValue createIssue(User remoteUser, Issue issue) throws CreateException {
        try {
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("issue", issue);
            MutableIssue originalIssueGV = ComponentAccessor.getIssueManager().getIssueObject(issue.getId());
            fields.put("originalissueobject", originalIssueGV);
            GenericValue issueGV = this.workflowManager.createIssue(remoteUser != null ? remoteUser.getName() : null, fields);
            return issueGV;
        }
        catch (WorkflowException workflowException) {
            Throwable cause = workflowException.getCause();
            if (cause instanceof InvalidInputException) {
                throw new CreateException("Error occurred while creating issue through workflow: " + cause.getMessage(), (Exception)((InvalidInputException)cause));
            }
            throw new CreateException((Exception)((Object)workflowException));
        }
    }

    public List<GenericValue> getProjectIssues(GenericValue project) throws GenericEntityException {
        return project.getRelated("ChildIssue");
    }

    public boolean isEditable(Issue issue) {
        return this.workflowManager.isEditable(issue);
    }

    public boolean isEditable(Issue issue, User user) {
        return this.isEditable(issue) && this.permissionManager.hasPermission(12, issue, user);
    }

    public GenericValue createIssue(String remoteUserName, Map<String, Object> fields) throws CreateException {
        try {
            GenericValue issue = this.workflowManager.createIssue(remoteUserName, fields);
            return issue;
        }
        catch (WorkflowException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof InvalidInputException) {
                throw new CreateException("Error occurred while creating issue through workflow: " + cause.getMessage(), (Exception)((InvalidInputException)cause));
            }
            throw new CreateException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public Issue createIssueObject(String remoteUserName, Map<String, Object> fields) throws CreateException {
        return this.getIssueFactory().getIssue(this.createIssue(remoteUserName, fields));
    }

    public Issue createIssueObject(User remoteUser, Map<String, Object> fields) throws CreateException {
        return this.getIssueFactory().getIssue(this.createIssue(remoteUser, fields));
    }

    public Issue createIssueObject(User remoteUser, Issue issue) throws CreateException {
        return this.getIssueFactory().getIssue(this.createIssue(remoteUser, issue));
    }

    public List<Issue> getVotedIssues(User user) throws GenericEntityException {
        return this.getVotedIssues(ApplicationUsers.from((User)user));
    }

    public List<Issue> getVotedIssuesOverrideSecurity(User user) throws GenericEntityException {
        return this.getVotedIssuesOverrideSecurity(ApplicationUsers.from((User)user));
    }

    public List<Issue> getVotedIssues(ApplicationUser user) {
        List<Issue> votedIssues = this.getVotedIssuesOverrideSecurity(user);
        IssueUtils.filterIssues(votedIssues, new NoBrowsePermissionPredicate(user));
        return votedIssues;
    }

    public List<Issue> getVotedIssuesOverrideSecurity(ApplicationUser user) {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("VoteIssue", user, "Issue");
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    private List<Issue> getIssueObjectsFromGVs(List<GenericValue> issueGVs) {
        Collections.sort(issueGVs, IssueKeyComparator.COMPARATOR);
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (GenericValue issue : issueGVs) {
            issues.add((Issue)this.getIssueObject(issue));
        }
        return issues;
    }

    public List<User> getWatchers(Issue issue) {
        return ApplicationUsers.toDirectoryUsers(this.getWatchersFor(issue));
    }

    public List<ApplicationUser> getWatchersFor(Issue issue) {
        return this.userAssociationStore.getUsersFromSink("WatchIssue", issue.getGenericValue());
    }

    public List<Issue> getWatchedIssues(User user) {
        return this.getWatchedIssues(ApplicationUsers.from((User)user));
    }

    public List<Issue> getWatchedIssuesOverrideSecurity(User user) {
        return this.getWatchedIssuesOverrideSecurity(ApplicationUsers.from((User)user));
    }

    public List<Issue> getWatchedIssues(ApplicationUser user) {
        List<Issue> watchedIssues = this.getWatchedIssuesOverrideSecurity(user);
        IssueUtils.filterIssues(watchedIssues, new NoBrowsePermissionPredicate(user));
        return watchedIssues;
    }

    public List<Issue> getWatchedIssuesOverrideSecurity(ApplicationUser user) {
        List<GenericValue> issueGVs = this.userAssociationStore.getSinksFromUser("WatchIssue", user, "Issue");
        return this.getIssueObjectsFromGVs(issueGVs);
    }

    public Issue updateIssue(User user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) {
        GenericValue originalIssueGV = issue.getGenericValue();
        StringBuffer modifiedText = new StringBuffer();
        DefaultIssueChangeHolder issueChangeHolder = this.updateFieldValues(issue, modifiedText);
        issue.resetModifiedFields();
        this.doUpdate(issue, originalIssueGV, eventDispatchOption, user, sendMail, issueChangeHolder);
        return issue;
    }

    protected void doUpdate(MutableIssue issue, GenericValue originalIssueGV, EventDispatchOption eventDispatchOption, User user, boolean sendMail, DefaultIssueChangeHolder issueChangeHolder) {
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean(issue.getGenericValue(), originalIssueGV, eventDispatchOption.getEventTypeId(), user, sendMail, true);
        issueUpdateBean.setComment(issueChangeHolder.getComment());
        issueUpdateBean.setChangeItems((Collection)issueChangeHolder.getChangeItems());
        issueUpdateBean.setDispatchEvent(eventDispatchOption.isEventBeingSent());
        issueUpdateBean.setParams(MapBuilder.newBuilder((Object)"eventsource", (Object)"action").toMutableMap());
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    protected DefaultIssueChangeHolder updateFieldValues(MutableIssue issue, StringBuffer modifiedText) {
        DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
        Map modifiedFields = issue.getModifiedFields();
        for (String fieldId : modifiedFields.keySet()) {
            if (!this.getFieldManager().isOrderableField(fieldId)) continue;
            OrderableField field = this.getFieldManager().getOrderableField(fieldId);
            FieldLayoutItem fieldLayoutItem = this.getFieldLayoutManager().getFieldLayout((Issue)issue).getFieldLayoutItem(field);
            ModifiedValue modifiedValue = (ModifiedValue)modifiedFields.get(fieldId);
            field.updateValue(fieldLayoutItem, (Issue)issue, modifiedValue, (IssueChangeHolder)issueChangeHolder);
            if (!"description".equals(fieldId) && !"environment".equals(fieldId)) continue;
            modifiedText.append(modifiedValue != null ? modifiedValue.getNewValue() : "").append(" ");
        }
        return issueChangeHolder;
    }

    public void deleteIssue(User user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssue(user, issue, eventDispatchOption, sendMail);
    }

    public void deleteIssue(User user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssue(user, (Issue)issue, eventDispatchOption, sendMail);
    }

    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssueNoEvent(issue);
    }

    public void deleteIssueNoEvent(MutableIssue issue) throws RemoveException {
        this.getIssueDeleteHelper().deleteIssueNoEvent((Issue)issue);
    }

    @VisibleForTesting
    protected MutableIssue getIssueObject(GenericValue issueGV) {
        if (issueGV == null) {
            return null;
        }
        return this.getIssueFactory().getIssue(issueGV);
    }

    private IssueFactory getIssueFactory() {
        return ComponentAccessor.getIssueFactory();
    }

    private ProjectManager getProjectManager() {
        return ComponentAccessor.getProjectManager();
    }

    FieldLayoutManager getFieldLayoutManager() {
        if (this.fieldLayoutManager == null) {
            this.fieldLayoutManager = ComponentAccessor.getFieldLayoutManager();
        }
        return this.fieldLayoutManager;
    }

    FieldManager getFieldManager() {
        if (this.fieldManager == null) {
            this.fieldManager = ComponentAccessor.getFieldManager();
        }
        return this.fieldManager;
    }

    IssueDeleteHelper getIssueDeleteHelper() {
        if (this.issueDeleteHelper == null) {
            this.issueDeleteHelper = (IssueDeleteHelper)ComponentAccessor.getComponentOfType(IssueDeleteHelper.class);
        }
        return this.issueDeleteHelper;
    }

    @VisibleForTesting
    IssueFinder getIssueFinder() {
        return this.issueFinder;
    }

    @VisibleForTesting
    IssueFinder getCaseInsensitiveIssueFinder() {
        return this.caseInsensitiveIssueFinder;
    }

    abstract class IssueFinder {
        IssueFinder() {
        }

        public GenericValue getIssue(String key) throws GenericEntityException {
            if (key == null) {
                return null;
            }
            GenericValue issue = this.getIssueFromIssueEntity(key);
            if (issue == null) {
                Issue movedIssue = DefaultIssueManager.this.findMovedIssue(key);
                if (movedIssue == null) {
                    return null;
                }
                return movedIssue.getGenericValue();
            }
            return issue;
        }

        private GenericValue getIssueFromIssueEntity(String key) {
            IssueKey issueKey;
            try {
                issueKey = IssueKey.from((String)key);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
            Project project = this.getProjectByKey(issueKey.getProjectKey());
            if (project == null) {
                return null;
            }
            return this.getIssueFromIssueEntityByProjectAndNumber(project, issueKey.getIssueNumber());
        }

        private GenericValue getIssueFromIssueEntityByProjectAndNumber(Project project, Long issueNumber) {
            return EntityUtil.getOnly((List)DefaultIssueManager.this.ofBizDelegator.findByAnd("Issue", (Map)ImmutableMap.of((Object)"project", (Object)project.getId(), (Object)"number", (Object)issueNumber)));
        }

        protected abstract Project getProjectByKey(String var1);
    }
}

