/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelStore;
import com.atlassian.jira.issue.label.OfBizLabelStore;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@EventComponent
public class CachingLabelStore
implements LabelStore,
Startable {
    private final OfBizLabelStore delegateStore;
    private final Cache<CacheKey, Set<Label>> cache = CacheBuilder.newBuilder().maximumSize(1000).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<CacheKey, Set<Label>>(){

        public Set<Label> load(CacheKey key) throws Exception {
            return CachingLabelStore.this.delegateStore.getLabels(key.getIssueId(), key.getFieldId());
        }
    });

    public CachingLabelStore(OfBizLabelStore delegateStore) {
        this.delegateStore = delegateStore;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.invalidateAll();
    }

    @Override
    public Set<Label> getLabels(Long issueId, Long customFieldId) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        return (Set)this.cache.getUnchecked((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Label> setLabels(Long issueId, Long customFieldId, Set<String> labels) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        try {
            Set<Label> set = this.delegateStore.setLabels(issueId, customFieldId, labels);
            return set;
        }
        finally {
            this.cache.invalidate((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Label addLabel(Long issueId, Long customFieldId, String label) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        try {
            Label label2 = this.delegateStore.addLabel(issueId, customFieldId, label);
            return label2;
        }
        finally {
            this.cache.invalidate((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLabel(Long labelId, Long issueId, Long customFieldId) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        try {
            this.delegateStore.removeLabel(labelId, issueId, customFieldId);
        }
        finally {
            this.cache.invalidate((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> removeLabelsForCustomField(Long customFieldId) {
        try {
            Set<Long> set = this.delegateStore.removeLabelsForCustomField(customFieldId);
            return set;
        }
        finally {
            this.cache.invalidateAll();
        }
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(CachingLabelStore.class.getSimpleName()).addCache(this.cache).install();
    }

    static final class CacheKey {
        private final Long issueId;
        private final Long fieldId;

        CacheKey(Long issueId, Long fieldId) {
            this.issueId = issueId;
            this.fieldId = fieldId;
        }

        public Long getFieldId() {
            return this.fieldId;
        }

        public Long getIssueId() {
            return this.issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.fieldId != null ? !this.fieldId.equals(cacheKey.fieldId) : cacheKey.fieldId != null) {
                return false;
            }
            return this.issueId.equals(cacheKey.issueId);
        }

        public int hashCode() {
            int result = this.issueId.hashCode();
            result = 31 * result + (this.fieldId != null ? this.fieldId.hashCode() : 0);
            return result;
        }
    }
}

