/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.AbstractLanguageAnalyser;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.SnowballProgram;

public class SnowballAnalyzer
extends AbstractLanguageAnalyser {
    private final Version matchVersion;
    private final Set<?> stopWords;
    private final Class<SnowballProgram> stemmerClass;

    public SnowballAnalyzer(Version matchVersion, boolean indexing, Set<?> stopWords, Class stemmerClass) {
        super(indexing);
        this.matchVersion = matchVersion;
        this.stopWords = stopWords;
        this.stemmerClass = stemmerClass;
    }

    public final TokenStream tokenStream(String fieldname, Reader reader) {
        ClassicTokenizer result = new ClassicTokenizer(this.matchVersion, reader);
        result = new StandardFilter(this.matchVersion, (TokenStream)result);
        result = this.wrapStreamForIndexing((TokenStream)result);
        result = new LowerCaseFilter(this.matchVersion, (TokenStream)result);
        result = new StopFilter(this.matchVersion, (TokenStream)result, this.stopWords);
        result = this.wrapStreamForWilcardSearchSupport((TokenStream)result);
        result = new SnowballFilter((TokenStream)result, this.getStemmer());
        return result;
    }

    private SnowballProgram getStemmer() {
        try {
            return this.stemmerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

