/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.analyzer;

import com.atlassian.jira.issue.index.analyzer.SubtokenFilter;
import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;

abstract class AbstractLanguageAnalyser
extends Analyzer {
    private final boolean indexing;

    public AbstractLanguageAnalyser(boolean indexing) {
        this.indexing = indexing;
    }

    public boolean isIndexing() {
        return this.indexing;
    }

    protected TokenStream wrapStreamForIndexing(TokenStream result) {
        if (this.isIndexing()) {
            return new SubtokenFilter(result);
        }
        return result;
    }

    protected TokenStream wrapStreamForWilcardSearchSupport(TokenStream result) {
        if (this.isIndexing()) {
            return new KeywordRepeatFilter(result);
        }
        return result;
    }

    public final TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return super.reusableTokenStream(fieldName, reader);
    }
}

