/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.layout.field;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.comparator.IssueTypeKeyComparator;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.fields.screen.AbstractGVBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import org.ofbiz.core.entity.GenericValue;

public class FieldLayoutSchemeEntityImpl
extends AbstractGVBean
implements FieldLayoutSchemeEntity {
    private final FieldLayoutManager fieldLayoutManager;
    private final ConstantsManager constantsManager;
    private final IssueTypeKeyComparator issueTypeKeyComparator;
    private Long id;
    private String issueTypeId;
    private Long fieldLayoutId;
    private FieldLayoutScheme fieldLayoutScheme;

    public FieldLayoutSchemeEntityImpl(FieldLayoutManager fieldLayoutManager, GenericValue genericValue, ConstantsManager constantsManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.constantsManager = constantsManager;
        this.issueTypeKeyComparator = new IssueTypeKeyComparator(constantsManager);
        this.setGenericValue(genericValue);
        this.init();
    }

    public Long getId() {
        return this.id;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public GenericValue getIssueType() {
        if (this.getIssueTypeId() != null) {
            return this.constantsManager.getIssueType(this.getIssueTypeId());
        }
        return null;
    }

    public IssueType getIssueTypeObject() {
        if (this.getIssueTypeId() != null) {
            return this.constantsManager.getIssueTypeObject(this.getIssueTypeId());
        }
        return null;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
        this.updateGV("issuetype", issueTypeId);
    }

    public Long getFieldLayoutId() {
        return this.fieldLayoutId;
    }

    public void setFieldLayoutId(Long fieldLayoutId) {
        this.fieldLayoutId = fieldLayoutId;
        this.updateGV("fieldlayout", fieldLayoutId);
    }

    public FieldLayoutScheme getFieldLayoutScheme() {
        return this.fieldLayoutScheme;
    }

    public void setFieldLayoutScheme(FieldLayoutScheme fieldLayoutScheme) {
        this.fieldLayoutScheme = fieldLayoutScheme;
        if (fieldLayoutScheme != null) {
            this.updateGV("scheme", fieldLayoutScheme.getId());
        } else {
            this.updateGV("scheme", null);
        }
    }

    @Override
    protected void init() {
        if (this.getGenericValue() != null) {
            this.id = this.getGenericValue().getLong("id");
            this.issueTypeId = this.getGenericValue().getString("issuetype");
            this.fieldLayoutId = this.getGenericValue().getLong("fieldlayout");
        }
        this.setModified(false);
    }

    public void store() {
        if (this.isModified()) {
            if (this.getGenericValue() == null) {
                this.fieldLayoutManager.createFieldLayoutSchemeEntity((FieldLayoutSchemeEntity)this);
            } else {
                this.fieldLayoutManager.updateFieldLayoutSchemeEntity((FieldLayoutSchemeEntity)this);
            }
        }
    }

    public void remove() {
        if (this.getGenericValue() != null) {
            this.fieldLayoutManager.removeFieldLayoutSchemeEntity((FieldLayoutSchemeEntity)this);
        }
    }

    public int compareTo(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        return this.issueTypeKeyComparator.compare(this.getIssueTypeId(), fieldLayoutSchemeEntity.getIssueTypeId());
    }
}

